% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{idct_rate}
\alias{idct_rate}
\title{Inverse Discrete Cosine Transform Rate}
\usage{
idct_rate(y, n = length(y))
}
\arguments{
\item{y}{DCT coefficients}

\item{n}{The desired length of the idct}
}
\value{
A vector with the first derivative
of the inverse DCT
}
\description{
The first derivative of the Inverse DCT
}
\details{
Returns the first derivative (rate of change) of
the Inverse DCT (see \link{dct} for more details).

\deqn{
\frac{\delta x_j}{\delta j} = -2\frac{\pi k}{J}\sum_{k=1}^{N-1} y_k \sin\left(\frac{\pi k(2j+1)}{2J}\right)
}
}
\examples{
x <- seq(0, 1, length = 10)
y <- 5 + x + (2 * (x^2)) + (-2 * (x^4))

dct_coefs <- dct(y)
y_rate <- idct_rate(dct_coefs)

plot(y)
plot(y_rate)

}
