% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{idct}
\alias{idct}
\alias{idct.numeric}
\alias{idct.matrix}
\title{Inverse Discrete Cosine Transform}
\usage{
idct(y, n)

\method{idct}{numeric}(y, n = length(y))

\method{idct}{matrix}(y, n = nrow(y))
}
\arguments{
\item{y}{A vector or matrix of DCT coefficients}

\item{n}{The desired length of the idct}
}
\value{
The returned value depends on the values in \code{y}.

When passed a numeric vector, returns numeric vector of length \code{n}.

When passed a matrix, returns a matrix with \code{n} rows and the same number of columns as \code{y}.
}
\description{
The Inverse DCT
}
\details{
Applies the Inverse DCT (see \link{dct} for more details).

\deqn{
x_j = \sqrt{2}y_0 + 2\sum_{k=1}^{N-1} y_k \cos\left(\frac{\pi k(2j+1)}{2J}\right)
}
}
\examples{
x <- seq(0, 1, length = 10)
y <- 5 + x + (2 * (x^2)) + (-2 * (x^4))

dct_coefs <- dct(y)
recovered_y <- idct(dct_coefs)

plot(y, recovered_y)

}
\keyword{internal}
