% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_cfg.R
\name{HTE_cfg}
\alias{HTE_cfg}
\title{Configuration of Quantities of Interest}
\description{
\code{HTE_cfg} is a configuration class that pulls everything together, indicating
the full configuration for a given HTE analysis. This includes how to estimate
models and what Quantities of Interest to calculate based off those underlying models.
}
\examples{

## ------------------------------------------------
## Method `HTE_cfg$new`
## ------------------------------------------------

mcate_cfg <- MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
pcate_cfg <- PCATE_cfg$new(
   cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)),
   model_covariates = c("x1", "x2", "x3"),
   num_mc_samples = list(x1 = 100)
)
vimp_cfg <- VIMP_cfg$new()
diag_cfg <- Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)
qoi_cfg <- QoI_cfg$new(
    mcate = mcate_cfg,
    pcate = pcate_cfg,
    vimp = vimp_cfg,
    diag = diag_cfg
)
ps_cfg <- SLEnsemble_cfg$new(
   learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
y_cfg <- SLEnsemble_cfg$new(
   learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
fx_cfg <- SLEnsemble_cfg$new(
   learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
HTE_cfg$new(outcome = y_cfg, treatment = ps_cfg, effect = fx_cfg, qoi = qoi_cfg)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{outcome}}{\code{Model_cfg} object indicating how outcome models should be estimated.}

\item{\code{treatment}}{\code{Model_cfg} object indicating how the propensity score
model should be estimated.}

\item{\code{effect}}{\code{Model_cfg} object indicating how the joint effect model
should be estimated.}

\item{\code{qoi}}{\code{QoI_cfg} object indicating what the Quantities of Interest
are and providing all
necessary detail on how they should be estimated.}

\item{\code{verbose}}{Logical indicating whether to print debugging information.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HTE_cfg-new}{\code{HTE_cfg$new()}}
\item \href{#method-HTE_cfg-clone}{\code{HTE_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTE_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-HTE_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{HTE_cfg} object with all necessary information about how
to carry out an HTE analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTE_cfg$new(
  outcome = NULL,
  treatment = NULL,
  effect = NULL,
  qoi = NULL,
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{outcome}}{\code{Model_cfg} object indicating how outcome models should
be estimated.}

\item{\code{treatment}}{\code{Model_cfg} object indicating how the propensity score
model should be estimated.}

\item{\code{effect}}{\code{Model_cfg} object indicating how the joint effect model
should be estimated.}

\item{\code{qoi}}{\code{QoI_cfg} object indicating what the Quantities of Interest
are and providing all
necessary detail on how they should be estimated.}

\item{\code{verbose}}{Logical indicating whether to print debugging information.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{mcate_cfg <- MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
pcate_cfg <- PCATE_cfg$new(
   cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)),
   model_covariates = c("x1", "x2", "x3"),
   num_mc_samples = list(x1 = 100)
)
vimp_cfg <- VIMP_cfg$new()
diag_cfg <- Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)
qoi_cfg <- QoI_cfg$new(
    mcate = mcate_cfg,
    pcate = pcate_cfg,
    vimp = vimp_cfg,
    diag = diag_cfg
)
ps_cfg <- SLEnsemble_cfg$new(
   learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
y_cfg <- SLEnsemble_cfg$new(
   learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
fx_cfg <- SLEnsemble_cfg$new(
   learner_cfgs = list(SLLearner_cfg$new("SL.glm"), SLLearner_cfg$new("SL.gam"))
)
HTE_cfg$new(outcome = y_cfg, treatment = ps_cfg, effect = fx_cfg, qoi = qoi_cfg)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTE_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HTE_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTE_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
