% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{setna_scale}
\alias{setna_scale}
\title{Set specified values to NA in selected variables or entire data frame}
\usage{
setna_scale(data, ..., value, name = NULL, overwrite = FALSE)
}
\arguments{
\item{data}{A \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model.}

\item{...}{One or more variables where specified values will be set to NA.
If no variables are provided, the function is applied to the entire data frame.}

\item{value}{A value (or vector of values) that needs to be set to NA.}

\item{name}{The name of the new variable(s). By default, this is the same name
as the provided variable(s) but suffixed with \verb{_na}.}

\item{overwrite}{Logical. If \code{TRUE}, it overwrites the original variable(s).
You cannot specify both 'name' and 'overwrite' parameters simultaneously.}
}
\value{
A \link{tdcmm} model or a tibble.
}
\description{
This function allows users to set specific values to \code{NA} in chosen variables
within a data frame. It can handle numeric, character, and factor variables.
}
\examples{
WoJ \%>\%
dplyr::select(autonomy_emphasis) \%>\%
setna_scale(autonomy_emphasis, value = 5)
WoJ \%>\%
dplyr::select(autonomy_emphasis) \%>\%
setna_scale(autonomy_emphasis, value = 5, name = "new_na_autonomy")
WoJ \%>\%
setna_scale(value = c(2, 3, 4), overwrite = TRUE)
WoJ \%>\%
dplyr::select(country) \%>\% setna_scale(country, value = "Germany")
WoJ \%>\%
dplyr::select(country) \%>\% setna_scale(country, value = c("Germany", "Switzerland"))
}
\seealso{
Other scaling: 
\code{\link{categorize_scale}()},
\code{\link{center_scale}()},
\code{\link{dummify_scale}()},
\code{\link{minmax_scale}()},
\code{\link{recode_cat_scale}()},
\code{\link{reverse_scale}()},
\code{\link{z_scale}()}
}
\concept{scaling}
