% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture-pseudo_class.R
\name{pseudo_class}
\alias{pseudo_class}
\alias{pseudo_class.MxModel}
\title{Estimate an Auxiliary Model using the Pseudo-Class Method}
\usage{
pseudo_class(x, model, df_complete = NULL, ...)

\method{pseudo_class}{MxModel}(x, model, df_complete = NULL, data = NULL, m = 20, ...)
}
\arguments{
\item{x}{An object for which a method exists, typically either a fitted
\code{mx_mixture} model or \code{class_draws} object.}

\item{model}{Either an expression to execute on every generated dataset,
or a function that performs the analysis on every generated dataset,
or a character that can be interpreted as a structural equation model using
\code{\link[tidySEM]{as_ram}}. This \code{model} can explicitly refer to \code{data}.}

\item{df_complete}{Integer. Degrees of freedom of the complete-data analysis.}

\item{...}{Additional arguments passed to other functions.}

\item{data}{A data.frame on which the auxiliary model can be evaluated. Note
that the row order must be identical to that of the data used to fit \code{x},
as these data will be augmented with a pseudo-class draw for that specific
individual.}

\item{m}{Integer. Number of datasets to generate. Default is 20.}
}
\value{
An object of class \code{\link[base]{data.frame}} containing pooled
estimates.
}
\description{
Estimate an auxiliary model based on multiple datasets, randomly drawing
latent class values based on the estimated probability of belonging to each
class. The pseudo class variable is treated as an observed variable within
each dataset, and results are pooled across datasets to account for
classification uncertainty.
}
\examples{
if(requireNamespace("OpenMx", quietly = TRUE)){
library(OpenMx)
set.seed(2)
dat <- iris[c(1:5, 50:55, 100:105), 1:4]
colnames(dat) <- c("SL", "SW", "PL", "PW")
fit <- suppressWarnings(mx_profiles(data = dat, classes = 3))

pct_mx <- pseudo_class(x = fit,
                       model = "SL ~ class",
                       data = dat,
                       m = 2)

pct_lm <- pseudo_class(x = fit,
             model = lm( SL ~ class, data = data),
             data = dat,
             m = 2)


pcte <- pseudo_class(x = fit,
                     model = lm(SL ~ class, data = data),
                     data = dat,
                     m = 2)

pct_func <- pseudo_class(x = fit,
                         model = function(data){lm(SL ~ class, data = data)},
                         data = dat,
                         m = 2)


}

}
\references{
Pseudo-class technique:
Wang C-P, Brown CH, Bandeen-Roche K (2005). Residual Diagnostics for Growth
Mixture Models: Examining the Impact of a Preventive Intervention on
Multiple Trajectories of Aggressive Behavior. Journal of the American
Statistical Association 100(3):1054-1076. \doi{10.1198/016214505000000501}

Pooling results across samples:
Van Buuren, S. 2018. Flexible Imputation of Missing Data. Second Edition.
Boca Raton, FL: Chapman & Hall/CRC. \doi{10.1201/9780429492259}
}
