% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{input_heatmap}
\alias{input_heatmap}
\title{input_heatmap}
\source{
[Mangiola and Papenfuss., 2020](https://joss.theoj.org/papers/10.21105/joss.02472)
}
\usage{
input_heatmap(
  .data,
  .horizontal,
  .vertical,
  .abundance,
  transform = NULL,
  scale = "none",
  palette_value = c("#440154FF", "#21908CFF", "#fefada"),
  palette_grouping = list(),
  ...
)
}
\arguments{
\item{.data}{A `tbl` formatted as | <SAMPLE> | <TRANSCRIPT> | <COUNT> | <...> |}

\item{.horizontal}{The name of the column horizontally presented in the heatmap}

\item{.vertical}{The name of the column vertically presented in the heatmap}

\item{.abundance}{The name of the transcript/gene abundance column}

\item{transform}{A function, used to transform .value, for example log1p}

\item{scale}{A character string. Possible values are c(\"none\", \"row\", \"column\", \"both\")}

\item{palette_value}{A character vector, or a function for higher customisation (colorRamp2). This is the palette that will be used as gradient for abundance. If palette_value is a vector of hexadecimal colours, it should have 3 values. If you want more customisation, you can pass to palette_value a function, that is derived as for example `colorRamp2(c(-2, 0, 2), palette_value)`}

\item{palette_grouping}{A list of character vectors. This is the list of palettes that will be used for grouping}

\item{...}{Further arguments to be passed to ComplexHeatmap::Heatmap}
}
\value{
A `ComplexHeatmap` object
}
\description{
input_heatmap() takes a tbl object and easily produces a ComplexHeatmap plot, with integration with tibble and dplyr frameworks.
}
\details{
To be added.
}
\references{
Mangiola, S. and Papenfuss, A.T., 2020. "tidyHeatmap: an R package for 
  modular heatmap production based on tidy principles." Journal of Open Source Software.
  doi:10.21105/joss.02472.
}
