% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_significance}
\alias{add_significance}
\title{Add Significance Asterisks}
\usage{
add_significance(x, p_column = NULL, ci_lb = NULL, ci_up = NULL, alpha = 0.05)
}
\arguments{
\item{x}{A \code{data.frame}}

\item{p_column}{Atomic character, referring to the name of the column of
p-values. If this is provided, the confidence interval is ignored. Default:
\code{NULL}}

\item{ci_lb}{Atomic character, referring to the name of the column of
the lower bound of a confidence interval. Default: \code{NULL}}

\item{ci_up}{Atomic character, referring to the name of the column of
the upper bound of a confidence interval. Default: \code{NULL}}

\item{alpha}{Significance level, default: \code{.05}}
}
\value{
A \code{data.frame}
}
\description{
Given a \code{data.frame} with a column containing p-values or two columns
containing the lower- and upper bounds of a confidence interval, adds a
column of significance asterisks.
}
\examples{
tmp <- add_significance(head(iris))
}
