% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_pixel_cnn}
\alias{tfd_pixel_cnn}
\title{The Pixel CNN++ distribution}
\usage{
tfd_pixel_cnn(
  image_shape,
  conditional_shape = NULL,
  num_resnet = 5,
  num_hierarchies = 3,
  num_filters = 160,
  num_logistic_mix = 10,
  receptive_field_dims = c(3, 3),
  dropout_p = 0.5,
  resnet_activation = "concat_elu",
  use_weight_norm = TRUE,
  use_data_init = TRUE,
  high = 255,
  low = 0,
  dtype = tf$float32,
  name = "PixelCNN"
)
}
\arguments{
\item{image_shape}{3D \code{TensorShape} or tuple for the \verb{[height, width, channels]}
dimensions of the image.}

\item{conditional_shape}{\code{TensorShape} or tuple for the shape of the
conditional input, or \code{NULL} if there is no conditional input.}

\item{num_resnet}{\code{integer}, the number of layers (shown in Figure 2 of https://arxiv.org/abs/1606.05328)
within each highest-level block of Figure 2 of https://pdfs.semanticscholar.org/9e90/6792f67cbdda7b7777b69284a81044857656.pdf.}

\item{num_hierarchies}{\code{integer}, the number of hightest-level blocks (separated by
expansions/contractions of dimensions in Figure 2 of https://pdfs.semanticscholar.org/9e90/6792f67cbdda7b7777b69284a81044857656.pdf.)}

\item{num_filters}{\code{integer}, the number of convolutional filters.}

\item{num_logistic_mix}{\code{integer}, number of components in the logistic mixture
distribution.}

\item{receptive_field_dims}{\code{tuple}, height and width in pixels of the receptive
field of the convolutional layers above and to the left of a given
pixel. The width (second element of the tuple) should be odd. Figure 1
(middle) of https://arxiv.org/abs/1606.05328 shows a receptive field of (3, 5)
(the row containing the current pixel is included in the height).
The default of (3, 3) was used to produce the results in https://pdfs.semanticscholar.org/9e90/6792f67cbdda7b7777b69284a81044857656.pdf.}

\item{dropout_p}{\code{float}, the dropout probability. Should be between 0 and 1.}

\item{resnet_activation}{\code{string}, the type of activation to use in the resnet blocks.
May be 'concat_elu', 'elu', or 'relu'.}

\item{use_weight_norm}{\code{logical}, if \code{TRUE} then use weight normalization (works
only in Eager mode).}

\item{use_data_init}{\code{logical}, if \code{TRUE} then use data-dependent initialization
(has no effect if \code{use_weight_norm} is \code{FALSE}).}

\item{high}{\code{integer}, the maximum value of the input data (255 for an 8-bit image).}

\item{low}{\code{integer}, the minimum value of the input data.}

\item{dtype}{Data type of the \code{Distribution}.}

\item{name}{\code{string}, the name of the \code{Distribution}.}
}
\value{
a distribution instance.
}
\description{
Pixel CNN++ (Salimans et al., 2017) models a distribution over image
data, parameterized by a neural network. It builds on Pixel CNN and
Conditional Pixel CNN, as originally proposed by
(van den Oord et al., 2016).
The model expresses the joint distribution over pixels as
the product of conditional distributions:
\verb{p(x|h) = prod\{ p(x[i] | x[0:i], h) : i=0, ..., d \}}, in which
\verb{p(x[i] | x[0:i], h) : i=0, ..., d} is the
probability of the \code{i}-th pixel conditional on the pixels that preceded it in
raster order (color channels in RGB order, then left to right, then top to
bottom). \code{h} is optional additional data on which to condition the image
distribution, such as class labels or VAE embeddings. The Pixel CNN++
network enforces the dependency structure among pixels by applying a mask to
the kernels of the convolutional layers that ensures that the values for each
pixel depend only on other pixels up and to the left.
Pixel values are modeled with a mixture of quantized logistic distributions,
which can take on a set of distinct integer values (e.g. between 0 and 255
for an 8-bit image).
Color intensity \code{v} of each pixel is modeled as:
\verb{v ~ sum\{q[i] * quantized_logistic(loc[i], scale[i]) : i = 0, ..., k \}},
in which \code{k} is the number of mixture components and the \code{q[i]} are the
Categorical probabilities over the components.
}
\section{References}{

\itemize{
\item \href{https://www.semanticscholar.org/paper/OTHER-MODIFICATIONS-Karpathy/2e77b99e8bd10b9e4551a780c0bde9dd10fdbe9b?p2df}{Tim Salimans, Andrej Karpathy, Xi Chen, and Diederik P. Kingma. PixelCNN++: Improving the PixelCNN with Discretized Logistic Mixture Likelihood and Other Modifications. In \emph{International Conference on Learning Representations}, 2017.}
\item \href{https://arxiv.org/abs/1606.05328}{Aaron van den Oord, Nal Kalchbrenner, Oriol Vinyals, Lasse Espeholt, Alex Graves, and Koray Kavukcuoglu. Conditional Image Generation with PixelCNN Decoders. In \emph{Neural Information Processing Systems}, 2016.}
\item \href{https://arxiv.org/pdf/1601.06759.pdf}{Aaron van den Oord, Nal Kalchbrenner, and Koray Kavukcuoglu. Pixel Recurrent Neural Networks. In \emph{International Conference on Machine Learning}, 2016.}
}
}

\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
