% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_exp_relaxed_one_hot_categorical}
\alias{tfd_exp_relaxed_one_hot_categorical}
\title{ExpRelaxedOneHotCategorical distribution with temperature and logits.}
\usage{
tfd_exp_relaxed_one_hot_categorical(
  temperature,
  logits = NULL,
  probs = NULL,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = "ExpRelaxedOneHotCategorical"
)
}
\arguments{
\item{temperature}{An 0-D Tensor, representing the temperature of a set of
ExpRelaxedCategorical distributions. The temperature should be positive.}

\item{logits}{An N-D Tensor, N >= 1, representing the log probabilities of a
set of ExpRelaxedCategorical distributions. The first N - 1 dimensions index
into a batch of independent distributions and the last dimension represents a
vector of logits for each class. Only one of logits or probs should be passed
in.}

\item{probs}{An N-D Tensor, N >= 1, representing the probabilities of a set of
ExpRelaxedCategorical distributions. The first N - 1 dimensions index into a
batch of independent distributions and the last dimension represents a vector
of probabilities for each class. Only one of logits or probs should be passed
in.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
ExpRelaxedOneHotCategorical distribution with temperature and logits.
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.
}
