% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijectors.R
\name{tfb_masked_autoregressive_default_template}
\alias{tfb_masked_autoregressive_default_template}
\title{Masked Autoregressive Density Estimator}
\usage{
tfb_masked_autoregressive_default_template(
  hidden_layers,
  shift_only = FALSE,
  activation = tf$nn$relu,
  log_scale_min_clip = -5,
  log_scale_max_clip = 3,
  log_scale_clip_gradient = FALSE,
  name = NULL,
  ...
)
}
\arguments{
\item{hidden_layers}{list-like of non-negative integer, scalars indicating the number
of units in each hidden layer. Default: \code{list(512, 512)}.}

\item{shift_only}{logical indicating if only the shift term shall be
computed. Default: FALSE.}

\item{activation}{Activation function (callable). Explicitly setting to NULL implies a linear activation.}

\item{log_scale_min_clip}{float-like scalar Tensor, or a Tensor with the same shape as log_scale. The minimum value to clip by. Default: -5.}

\item{log_scale_max_clip}{float-like scalar Tensor, or a Tensor with the same shape as log_scale. The maximum value to clip by. Default: 3.}

\item{log_scale_clip_gradient}{logical indicating that the gradient of tf$clip_by_value should be preserved. Default: FALSE.}

\item{name}{A name for ops managed by this function. Default: "tfb_masked_autoregressive_default_template".}

\item{...}{\code{tf$layers$dense} arguments}
}
\value{
list of:
\itemize{
\item shift: \code{Float}-like \code{Tensor} of shift terms
\item log_scale: \code{Float}-like \code{Tensor} of log(scale) terms
}
}
\description{
This will be wrapped in a make_template to ensure the variables are only
created once. It takes the input and returns the loc ("mu" in
Germain et al. (2015)) and log_scale ("alpha" in Germain et al. (2015)) from
the MADE network.
}
\details{
Warning: This function uses masked_dense to create randomly initialized
\code{tf$Variables}. It is presumed that these will be fit, just as you would any
other neural architecture which uses \code{tf$layers$dense}.

About Hidden Layers
Each element of hidden_layers should be greater than the input_depth
(i.e., \code{input_depth = tf$shape(input)[-1]} where input is the input to the
neural network). This is necessary to ensure the autoregressivity property.

About Clipping
This function also optionally clips the log_scale (but possibly not its
gradient). This is useful because if log_scale is too small/large it might
underflow/overflow making it impossible for the MaskedAutoregressiveFlow
bijector to implement a bijection. Additionally, the log_scale_clip_gradient
bool indicates whether the gradient should also be clipped. The default does
not clip the gradient; this is useful because it still provides gradient
information (for fitting) yet solves the numerical stability problem. I.e.,
log_scale_clip_gradient = FALSE means \verb{grad[exp(clip(x))] = grad[x] exp(clip(x))}
rather than the usual \verb{grad[clip(x)] exp(clip(x))}.
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1502.03509}{Mathieu Germain, Karol Gregor, Iain Murray, and Hugo Larochelle. MADE: Masked Autoencoder for Distribution Estimation. In \emph{International Conference on Machine Learning}, 2015.}
}
}

\seealso{
For usage examples see \code{\link[=tfb_forward]{tfb_forward()}}, \code{\link[=tfb_inverse]{tfb_inverse()}}, \code{\link[=tfb_inverse_log_det_jacobian]{tfb_inverse_log_det_jacobian()}}.

Other bijectors: 
\code{\link{tfb_absolute_value}()},
\code{\link{tfb_affine}()},
\code{\link{tfb_affine_linear_operator}()},
\code{\link{tfb_affine_scalar}()},
\code{\link{tfb_ascending}()},
\code{\link{tfb_batch_normalization}()},
\code{\link{tfb_blockwise}()},
\code{\link{tfb_chain}()},
\code{\link{tfb_cholesky_outer_product}()},
\code{\link{tfb_cholesky_to_inv_cholesky}()},
\code{\link{tfb_correlation_cholesky}()},
\code{\link{tfb_cumsum}()},
\code{\link{tfb_discrete_cosine_transform}()},
\code{\link{tfb_exp}()},
\code{\link{tfb_expm1}()},
\code{\link{tfb_ffjord}()},
\code{\link{tfb_fill_scale_tri_l}()},
\code{\link{tfb_fill_triangular}()},
\code{\link{tfb_glow}()},
\code{\link{tfb_gompertz_cdf}()},
\code{\link{tfb_gumbel}()},
\code{\link{tfb_gumbel_cdf}()},
\code{\link{tfb_identity}()},
\code{\link{tfb_inline}()},
\code{\link{tfb_invert}()},
\code{\link{tfb_iterated_sigmoid_centered}()},
\code{\link{tfb_kumaraswamy}()},
\code{\link{tfb_kumaraswamy_cdf}()},
\code{\link{tfb_lambert_w_tail}()},
\code{\link{tfb_masked_autoregressive_flow}()},
\code{\link{tfb_masked_dense}()},
\code{\link{tfb_matrix_inverse_tri_l}()},
\code{\link{tfb_matvec_lu}()},
\code{\link{tfb_normal_cdf}()},
\code{\link{tfb_ordered}()},
\code{\link{tfb_pad}()},
\code{\link{tfb_permute}()},
\code{\link{tfb_power_transform}()},
\code{\link{tfb_rational_quadratic_spline}()},
\code{\link{tfb_rayleigh_cdf}()},
\code{\link{tfb_real_nvp}()},
\code{\link{tfb_real_nvp_default_template}()},
\code{\link{tfb_reciprocal}()},
\code{\link{tfb_reshape}()},
\code{\link{tfb_scale}()},
\code{\link{tfb_scale_matvec_diag}()},
\code{\link{tfb_scale_matvec_linear_operator}()},
\code{\link{tfb_scale_matvec_lu}()},
\code{\link{tfb_scale_matvec_tri_l}()},
\code{\link{tfb_scale_tri_l}()},
\code{\link{tfb_shift}()},
\code{\link{tfb_shifted_gompertz_cdf}()},
\code{\link{tfb_sigmoid}()},
\code{\link{tfb_sinh}()},
\code{\link{tfb_sinh_arcsinh}()},
\code{\link{tfb_softmax_centered}()},
\code{\link{tfb_softplus}()},
\code{\link{tfb_softsign}()},
\code{\link{tfb_split}()},
\code{\link{tfb_square}()},
\code{\link{tfb_tanh}()},
\code{\link{tfb_transform_diagonal}()},
\code{\link{tfb_transpose}()},
\code{\link{tfb_weibull}()},
\code{\link{tfb_weibull_cdf}()}
}
\concept{bijectors}
