% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{step_numeric_column}
\alias{step_numeric_column}
\title{Creates a numeric column specification}
\usage{
step_numeric_column(
  spec,
  ...,
  shape = 1L,
  default_value = NULL,
  dtype = tf$float32,
  normalizer_fn = NULL
)
}
\arguments{
\item{spec}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{...}{Comma separated list of variable names to apply the step. \link{selectors} can also be used.}

\item{shape}{An iterable of integers specifies the shape of the Tensor. An integer can be given
which means a single dimension Tensor with given width. The Tensor representing the column will
have the shape of \code{batch_size} + \code{shape}.}

\item{default_value}{A single value compatible with \code{dtype} or an iterable of values compatible
with \code{dtype} which the column takes on during \code{tf.Example} parsing if data is missing. A
default value of \code{NULL} will cause \code{tf.parse_example} to fail if an example does not contain
this column. If a single value is provided, the same value will be applied as
the default value for every item. If an iterable of values is provided, the shape
of the default_value should be equal to the given shape.}

\item{dtype}{defines the type of values. Default value is \code{tf$float32}. Must be a non-quantized,
real integer or floating point type.}

\item{normalizer_fn}{If not \code{NULL}, a function that can be used to normalize the value
of the tensor after default_value is applied for parsing. Normalizer function takes the
input Tensor as its argument, and returns the output Tensor. (e.g. \verb{function(x) (x - 3.0) / 4.2)}.
Please note that even though the most common use case of this function is normalization, it
can be used for any kind of Tensorflow transformations. You can also a pre-made \link{scaler}, in
this case a function will be created after \link{fit.FeatureSpec} is called on the feature specification.}
}
\value{
a \code{FeatureSpec} object.
}
\description{
\code{step_numeric_column} creates a numeric column specification. It can also be
used to normalize numeric columns.
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ age) \%>\%
  step_numeric_column(age, normalizer_fn = standard_scaler())

spec_fit <- fit(spec)
final_dataset <- hearts \%>\% dataset_use_spec(spec_fit)
}

}
\seealso{
\link{steps} for a complete list of allowed steps.

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{fit.FeatureSpec}()},
\code{\link{step_bucketized_column}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_file}()},
\code{\link{step_categorical_column_with_vocabulary_list}()},
\code{\link{step_crossed_column}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_remove_column}()},
\code{\link{step_shared_embeddings_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
