% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textDistanceNorm}
\alias{textDistanceNorm}
\title{Semantic distance between a text variable and a word norm}
\usage{
textDistanceNorm(x, y, method = "euclidean", center = FALSE, scale = FALSE)
}
\arguments{
\item{x}{Word embeddings (from textEmbed()).}

\item{y}{Word embedding from textEmbed (from only one text).}

\item{method}{(character) Character string describing type of measure to be computed; default is
"euclidean" (see also measures from stats:dist() including "maximum", "manhattan", "canberra",
"binary" and "minkowski". It is also possible to use "cosine", which computes the cosine distance
(i.e., 1 - cosine(x, y)).}

\item{center}{(boolean; from base::scale) If center is TRUE then centering is done by subtracting
the embedding mean
(omitting NAs) of x from each of its dimension, and if center is FALSE, no centering is done.}

\item{scale}{(boolean; from base::scale) If scale is TRUE then scaling is done by dividing the
(centered) embedding dimensions by the standard deviation of the embedding if center is TRUE,
 and the root mean square otherwise.}
}
\value{
A vector comprising semantic distance scores.
}
\description{
textDistanceNorm() computes the semantic distance between a text variable and a word norm
(i.e., a text represented by one word embedding that represent a construct/concept).
}
\examples{
\dontrun{
library(dplyr)
library(tibble)
harmonynorm <- c("harmony peace ")
satisfactionnorm <- c("satisfaction achievement")

norms <- tibble::tibble(harmonynorm, satisfactionnorm)
word_embeddings <- word_embeddings_4$texts
word_embeddings_wordnorm <- textEmbed(norms)
similarity_scores <- textDistanceNorm(
  word_embeddings$harmonytext,
  word_embeddings_wordnorm$harmonynorm
)
}
}
\seealso{
see \code{\link{textDistance}}
}
