% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R, R/package.R
\name{install_tensorflow}
\alias{install_tensorflow}
\alias{py_require_tensorflow}
\title{Install TensorFlow and its dependencies}
\usage{
install_tensorflow(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  version = "default",
  envname = "r-tensorflow",
  extra_packages = NULL,
  restart_session = TRUE,
  conda_python_version = NULL,
  ...,
  cuda = NULL,
  metal = FALSE,
  pip_ignore_installed = FALSE,
  new_env = identical(envname, "r-tensorflow"),
  python_version = NULL
)

py_require_tensorflow(use_gpu = NA)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary.
See \strong{Finding Conda} and \code{\link[reticulate:conda_binary]{conda_binary()}} for more details.}

\item{version}{TensorFlow version to install. Valid values include:
\itemize{
\item \code{"default"} installs  2.20
\item \code{"release"} installs the latest release version of tensorflow (which may
be incompatible with the current version of the R package)
\item A version specification like \code{"2.4"} or \code{"2.4.0"}. Note that if the patch
version is not supplied, the latest patch release is installed (e.g.,
\code{"2.4"} today installs version "2.4.2")
\item \code{nightly} for the latest available nightly build.
\item To any specification, you can append "-cpu" to install the cpu version
only of the package (e.g., \code{"2.4-cpu"})
\item The full URL or path to a installer binary or python *.whl file.
}}

\item{envname}{The name, or full path, of the environment in which Python
packages are to be installed. When \code{NULL} (the default), the active
environment as set by the \code{RETICULATE_PYTHON_ENV} variable will be used;
if that is unset, then the \code{r-reticulate} environment will be used.}

\item{extra_packages}{Additional Python packages to install along with
TensorFlow.}

\item{restart_session}{Restart R session after installing (note this will
only occur within RStudio).}

\item{conda_python_version}{Passed to conda (only applicable if \code{method = "conda"})}

\item{...}{other arguments passed to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}, depending on the \code{method} used.}

\item{cuda}{logical \code{TRUE} or \code{FALSE}. If \code{install_tensorflow()} detects the
platform is Linux, an Nvidia GPU is available, and the TensorFlow version
is 2.14 (the default), it will install also install the required CUDA
libraries through pip.}

\item{metal}{Whether to install \code{tensorflow-metal} pip package on Arm Macs.
This enables tensorflow to use the GPU. Pass a string to install a specific
version like \verb{"tensorflow-metal==0.7.*}.}

\item{pip_ignore_installed}{Whether pip should ignore installed python
packages and reinstall all already installed python packages.}

\item{new_env}{If \code{TRUE}, any existing Python virtual environment and/or
conda environment specified by \code{envname} is deleted first.}

\item{python_version}{Select the Python that will be used to create the
virtualenv. Pass a string with version constraints like \code{"3.8"}, or
\code{">=3.9,<=3.11"} or a file path to a \code{python} executable like
\code{"/path/to/bin/python3"}. The supplied value is passed on to
\code{reticulate::virtualenv_starter()}. Note that the Python version must be
compatible with the requested TensorFlow version, documented here:
\url{https://www.tensorflow.org/install/pip#system-requirements}}

\item{use_gpu}{Only consulted if on Linux. It has no effect on macOS or
Windows. If \code{NA}, the R package will attempt to detect a GPU. If a GPU is
detected, then this is taken as \code{TRUE}, \code{FALSE} otherwise. If \code{TRUE}, then
\code{tensorflow[and-cuda]} is declared, otherwise, \code{tensorflow-cpu} is declared
via \code{py_require()}.}
}
\description{
This function installs TensorFlow into a persistant virtual environment.
Beginning with reticulate version 1.41, in most circumstances, creating a
persistent virtual environment by calling the \code{install_tensorflow()} function
is no longer necessary, because reticulate automatically will resolve a
python environment that satisfies all python requirements declared with
\code{reticulate::py_require()}.

New code is recommended to call \code{py_require_tensorflow()} at the start of an
R session to declare tensorflow requirements via \code{py_requore()}. In a future
package update this will by default be done in tensorflow's \code{.onLoad} hook.

The \code{py_require_tensorflow()} function that can dynamically modify the python
requirements to enable usage of a GPU if one is available and usable by the R
session.

The Python packages registered with \code{py_require()} by
\code{py_require_tensorflow()}:
\itemize{
\item On Linux: if a GPU is detected: \code{"tensorflow[and-cuda]"}, otherwise,
\code{"tensorflow-cpu"}.
\item On macOS: \code{"tensorflow"} is declared. The default package is not capable
of using the GPU. To enable TensorFlow usage of the GPU, call
\code{reticulate::py_require("tensorflow-metal")} before reticulate has
initialized Python. Note that not all features of TensorFlow work correctly
if \code{tensorflow-metal} is installed. There are known issues with random number
generators like \code{tf$random$stateless_uniform()}, likely others as well.
\item On Windows: \code{"tensorflow"} and \code{"numpy<2"} are declared. Note that
TensorFlow GPU usage on Windows is no longer supported (Since TensorFlow
2.10). To use a GPU on windows, use TensorFlow via WSL. \code{"numpy<2"} is
declared because at the time of this publishing, the pre-built binaries of
\code{tensorflow} for Windows are not compatible with \code{numpy>2}.
}

\code{install_tensorflow()} creates a new virtual environment containing the
\code{tensorflow} python package and it's direct dependencies. For creating a
virtual environment with more complete set packages that includes additional
optional dependencies, use \code{\link[keras3:install_keras]{keras3::install_keras()}}.
}
\section{Custom Installation}{
 \code{install_tensorflow()} or
\code{keras3::install_keras()} isn't required to use tensorflow with the
package. If you manually configure a python environment with the required
dependencies, you can tell R to use it by pointing reticulate at it,
commonly by setting an environment variable:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{Sys.setenv("RETICULATE_PYTHON" = "~/path/to/python-env/bin/python")
}\if{html}{\out{</div>}}
}

\section{Apple Silicon}{
 Beginning with Tensorflow version 2.13, the default
tensorflow package now works on Apple Silicon. See
\url{https://developer.apple.com/metal/tensorflow-plugin/} for instructions
on how to install older versions of Tensorflow on macOS. Please note that
not all operations are supported on Arm Mac GPUs. You can work around the
missing operations by pinning operations to CPU. For example:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{x <- array(runif(64*64), c(1, 64, 64))
keras3::layer_random_rotation(x, .5)  # Error:
# No registered 'RngReadAndSkip' OpKernel for 'GPU' devices
# Pin the operation to the CPU to avoid the error
with(tf$device("CPU"), keras3::layer_random_rotation(x, .5) ) # No Error
}\if{html}{\out{</div>}}
}

\section{Additional Packages}{


If you wish to add additional PyPI packages to your Keras / TensorFlow
environment you can either specify the packages in the \code{extra_packages}
argument of \code{install_tensorflow()} or \code{install_keras()}, or alternatively
install them into an existing environment using the
\code{\link[reticulate:py_install]{reticulate::py_install()}} function. Note that \code{install_keras()} includes a
set of additional python packages by default, see \code{?keras3::install_keras}
for details.
}

\seealso{
\itemize{
\item \code{\link[keras3:install_keras]{keras3::install_keras()}}
\item \url{https://tensorflow.rstudio.com/reference/tensorflow/install_tensorflow}
}
}
