% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asktell.R
\name{ask_Y}
\alias{ask_Y}
\title{ask&tell component function to 'ask' objective function evaluation.}
\usage{
ask_Y(
  x,
  id = 0,
  X.tmp = "X.todo",
  Y.tmp = "Y.done",
  tmp_path = file.path(tempdir(), "..", "asktell.tmp"),
  sleep_step = 0.1,
  sleep_init = 0,
  timeout = 360000,
  trace = function(...) cat(paste0(..., "\\n")),
  clean = TRUE,
  force_cleanup = FALSE
)
}
\arguments{
\item{x}{input values of objective function to compute}

\item{id}{unique identifier for this asktell loop (default: "0")}

\item{X.tmp}{temporary "X" values file (default: "X.todo")}

\item{Y.tmp}{temporary "Y" values file (default: "Y.done")}

\item{tmp_path}{temporary directory to store X.tmp & Y.tmp (default: 'tempdir()/../asktell.tmp')}

\item{sleep_step}{delay between checking X.tmp and Y.tmp (default: 0.1 sec.)}

\item{sleep_init}{initial delay before checking X.tmp and Y.tmp  (default: 0 sec.)}

\item{timeout}{maximum delay before breaking loop if X.tmp or Y.tmp doesn't appear (default: 36000 sec. = 10 min.) .}

\item{trace}{function to display asktell loop status (default : 'cat')}

\item{clean}{should we cleanup temporary files after reading ? (default: TRUE)}

\item{force_cleanup}{should we cleanup temporary files before writing (possible conflicting asktell calls) ? (default: FALSE)}
}
\value{
output value of objective function, as given by tell_Y() call in parallel session
}
\description{
ask&tell component function to 'ask' objective function evaluation.
}
\details{
'ask&tell' injection loop to call an external objective function within an inline algorithm (like optim(...))
Main idea: pass 'ask_Y' as objectve function argument of algorithm, which will wait until you call 'tell_Y' in another R process.
In this secondary process, you can read what X is called using 'ask_X', and when you know what values returns from the external objective, 
just call 'tell_Y' to give it.
}
\examples{
\dontrun{ ### Assumes you can use two independent R sessions
## In main R session
  ask_Y(x=123)
## In another R session
  ask_X() # returns 123
  tell_Y(y=456)
## Then ask_Y in main R session returns with value '456'
}
}
\author{
Y. Richet, discussions with D. Sinoquet. Async IO principle was defined by G. Pujol.
}
