% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_e0_alpha.R
\name{sampleE0}
\alias{sampleE0}
\title{Sample e0 conditional on partition and K using an
Metropolis-Hastings step with log-normal proposal.}
\usage{
sampleE0(K, Kp, N, Nk, s0_proposal, e0, log_p_e0)
}
\arguments{
\item{K}{A number; indicating the number of components.}

\item{Kp}{A number; indicating the number of filled components \eqn{K_+}.}

\item{N}{A number; indicating the sample size.}

\item{Nk}{An integer vector; indicating the group sizes in the partition.}

\item{s0_proposal}{A numeric value; indicating the standard deviation of the random walk proposal.}

\item{e0}{A numeric value; indicating the current value of \eqn{e_0}.}

\item{log_p_e0}{A function; evaluating the log prior of \eqn{e_0}.}
}
\value{
A named list containing:
\itemize{
\item \code{"e0"}: a numeric, the new \eqn{e_0} value.
\item \code{"acc"}: logical indicating acceptance.
}
}
\description{
Sample \eqn{e_0} conditional on the current partition
and value of \eqn{K} using an Metropolis-Hastings step with
log-normal proposal.
}
\keyword{internal}
