% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_teal_lockfile.R
\name{module_teal_lockfile}
\alias{module_teal_lockfile}
\alias{ui_teal_lockfile}
\alias{srv_teal_lockfile}
\alias{.teal_lockfile_process_invoke}
\alias{.renv_snapshot}
\alias{.is_lockfile_deps_installed}
\alias{.is_disabled_lockfile_scenario}
\title{Generate lockfile for application's environment reproducibility}
\usage{
ui_teal_lockfile(id)

srv_teal_lockfile(id)

.teal_lockfile_process_invoke(lockfile_path)

.renv_snapshot(lockfile_path)

.is_lockfile_deps_installed()

.is_disabled_lockfile_scenario()
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{lockfile_path}{(\code{character}) path to the lockfile.}
}
\value{
\code{NULL}
}
\description{
Generate lockfile for application's environment reproducibility
}
\section{Different ways of creating lockfile}{

\code{teal} leverages \code{\link[renv:snapshot]{renv::snapshot()}}, which offers multiple methods for lockfile creation.
\itemize{
\item \strong{Working directory lockfile}: \code{teal}, by default, will create an \code{implicit} type lockfile that uses
\code{renv::dependencies()} to detect all R packages in the current project's working directory.
\item \strong{\code{DESCRIPTION}-based lockfile}: To generate a lockfile based on a \code{DESCRIPTION} file in your working
directory, set \code{renv::settings$snapshot.type("explicit")}. The naming convention for \code{type} follows
\code{renv::snapshot()}. For the \code{"explicit"} type, refer to \code{renv::settings$package.dependency.fields()} for the
\code{DESCRIPTION} fields included in the lockfile.
\item \strong{Custom files-based lockfile}: To specify custom files as the basis for the lockfile, set
\code{renv::settings$snapshot.type("custom")} and configure the \code{renv.snapshot.filter} option.
}
}

\section{lockfile usage}{

After creating the lockfile, you can restore the application's environment using \code{renv::restore()}.
}

\seealso{
\code{\link[renv:snapshot]{renv::snapshot()}}, \code{\link[renv:restore]{renv::restore()}}.
}
\keyword{internal}
