% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_utils.R
\name{yaml_quoted}
\alias{yaml_quoted}
\title{Mark strings for quotation in \code{yaml} serialization}
\usage{
yaml_quoted(x)
}
\arguments{
\item{x}{(\code{character})}
}
\description{
This function is designed for use with the \code{yaml} package to explicitly,
It adds an attribute to character strings, indicating that they should be serialized with double quotes.
}
\examples{
library(yaml)
yaml_quoted <- getFromNamespace("yaml_quoted", "teal.reporter")
yaml <- list(
  author = yaml_quoted("NEST"),
  title = yaml_quoted("Report"),
  date = yaml_quoted("07/04/2019"),
  output = list(pdf_document = list(keep_tex = TRUE))
)
as.yaml(yaml)
}
\keyword{internal}
