% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_AUC.R
\name{get_AUC}
\alias{get_AUC}
\title{Calculate Area Under the Curve (AUC)}
\usage{
get_AUC(fit_method, lower, upper, ps, return.abs = FALSE, use.log = FALSE)
}
\arguments{
\item{fit_method}{Name of the model to calculate the area under the curve (AUC) for.}

\item{lower}{Lower concentration bound, usually is the lowest concentration in the data.}

\item{upper}{Upper concentration bound, usually is the highest concentration in the data.}

\item{ps}{Numeric vector (or list) of model parameters for the specified model in `fit_method`.}

\item{return.abs}{Logical argument, if TRUE, returns the absolute value of the AUC. Defaults to FALSE.}

\item{use.log}{Logical argument, defaults to FALSE. By default, the function estimates AUC with
concentrations in normal unit. If set to TRUE, will use concentration in log10-scale for
estimating AUC.}
}
\value{
AUC value (numeric)
}
\description{
Function that calculates the area under the curve (AUC) for dose-response curves.
}
\details{
This function takes in a model name and the respective set of model parameters,
and returns the area under the curve (AUC) between the specified lower and upper
concentration bounds. The AUC can be used to compute an efficacy/potency
metric for "active" dose-response curves. For decreasing curves, the AUC returned
will be negative. However, users have the option to return a positive AUC in
these cases. Model parameters should be entered as a numeric list or vector.
Models optimized on the log10-scale (hill and gain-loss), the lower and upper
concentration bounds, parameters "ga" (gain AC50) and "la" (loss AC50) will
be converted to log10-scale.
}
\examples{
conc <- c(.03,.1,.3,1,3,10,30,100)
fit_method <- "gnls"
modpars <- list(tp = 1.023, ga = 2.453, p = 1.592,
                la = 4288.993, q = 5.770, er = -3.295)
get_AUC("exp2", min(conc), max(conc), ps = modpars)

}
