% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Composite_table.R
\name{comp_table}
\alias{comp_table}
\alias{composite_table}
\alias{Composite_table}
\alias{comp_table_list}
\title{Compose Tables}
\usage{
comp_table(..., id_vars = NULL, meta = NULL)

comp_table_list(tables, id_vars = NULL, meta = NULL)
}
\arguments{
\item{...}{\code{comp_table()} only: individual \code{data.frames}. A name can be
provided for each \code{data.frame} that will be used by \code{\link[=print]{print()}} and
\code{\link[=as_workbook]{as_workbook()}} to create multi-table headings.}

\item{id_vars}{If \code{id_vars} is specified, the tables will be combined
using \code{\link[=merge]{merge()}} on the columns specified in \code{id_vars}, otherwise
the tables will be combined with \code{\link[=cbind]{cbind()}}.}

\item{meta}{a \link{TT_meta} object. If specified, the resulting
\code{Composite_table} will be wrapped in a \link{Tagged_table}.}

\item{tables}{\code{comp_table_list} only: A named list of data.frames with
the same number of rows}
}
\value{
A \code{Composite_table}.
}
\description{
\code{comp_table()} is a drop in replacement for \code{\link[base:cbind]{base::cbind()}} that supports
multi-column headings.#'
}
\examples{

df_mean <- data.frame(
  Species = c("setosa", "versicolor", "virginica"),
  length = c(5.01, 5.94, 6.59),
  width = c(3.43, 2.77, 2.97)
)

df_sd <- data.frame(
  Species = c("setosa", "versicolor", "virginica"),
  length = c(0.35, 0.52, 0.64),
  width = c(0.38, 0.31, 0.32)
)

comp_table(mean = df_mean, sd = df_sd)

# ...........mean............     ............sd.............
# 1    Species   length   width        Species   length   width
# 2     setosa     5.01    3.43         setosa     0.35    0.38
# 3 versicolor     5.94    2.77     versicolor     0.52    0.31
# 4  virginica     6.59    2.97      virginica     0.64    0.32


comp_table(mean = df_mean, sd = df_sd, id_vars = 'Species')

# ..........     .....mean.....     ......sd......
# 1    Species     length   width     length   width
# 2     setosa       5.01    3.43       0.35    0.38
# 3 versicolor       5.94    2.77       0.52    0.31
# 4  virginica       6.59    2.97       0.64    0.32

}
\seealso{
Attribute setter: \link{multinames<-}

Other Tatoo tables: 
\code{\link{mash_table}()},
\code{\link{stack_table}()},
\code{\link{tag_table}()},
\code{\link{tatoo_table}()}
}
\concept{Tatoo tables}
