% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_branch_names.R, R/tar_branch_names_raw.R
\name{tar_branch_names}
\alias{tar_branch_names}
\alias{tar_branch_names_raw}
\title{Branch names}
\usage{
tar_branch_names(name, index, store = targets::tar_config_get("store"))

tar_branch_names_raw(name, index, store = targets::tar_config_get("store"))
}
\arguments{
\item{name}{Name of the dynamic branching target.
\code{\link[=tar_branch_names]{tar_branch_names()}} expects an unevaluated symbol
for the \code{name} argument, whereas \code{\link[=tar_branch_names_raw]{tar_branch_names_raw()}}
expects a character string for \code{name}.}

\item{index}{Integer vector of branch indexes.}

\item{store}{Character string, directory path to the
\code{targets} data store of the pipeline.}
}
\value{
A character vector of branch names.
}
\description{
Get the branch names of a dynamic branching target
using numeric indexes.
\code{\link[=tar_branch_names]{tar_branch_names()}} expects an unevaluated symbol
for the \code{name} argument, whereas \code{\link[=tar_branch_names_raw]{tar_branch_names_raw()}}
expects a character string for \code{name}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(x, seq_len(4)),
    tar_target(y, 2 * x, pattern = map(x)),
    tar_target(z, y, pattern = map(y))
  )
}, ask = FALSE)
tar_make()
tar_branch_names(z, c(2, 3))
})
}
}
\seealso{
Other branching: 
\code{\link{tar_branch_index}()},
\code{\link{tar_branches}()},
\code{\link{tar_pattern}()}
}
\concept{branching}
