% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_tailplot.R
\name{pareto_tailplot}
\alias{pareto_tailplot}
\title{Plot the estimated t and the corresponding confidence intervals}
\usage{
pareto_tailplot(
  x,
  method = c("unbiased", "bootstrap", "jackknife"),
  R = 1000,
  conf.level = 0.95,
  ci.points = 101,
  xscale = "b"
)
}
\arguments{
\item{x}{a vector containing the sample data.}

\item{method}{the method used for computing the confidence intervals (options include unbiased variance estimator, jackknife, and bootstrap).}

\item{R}{the number of the bootstrap replicates.}

\item{conf.level}{the confidence level for the interval.}

\item{ci.points}{the number of thresholds used in the calculation of the confidence intervals.}

\item{xscale}{the scale of the x-axis (options include "o" = original, "l" = log scale, "b" = both).}
}
\value{
A plot showing the estimated \eqn{t(u)} versus threshold \eqn{u}, optionally on a logarithmic x-axis and including confidence intervals. Note that on the right side of the plot, one can observe the corresponding alpha values, which indicate the shape parameter of the Pareto distribution associated with the estimated t-values.
}
\description{
This function produces a tail plot for the estimate \eqn{\hat{t}} over a range of thresholds for a given sample, including confidence intervals computed by one of three methods (unbiased, bootstrap or jackknife). The function also allows a choice between original and log scale.
}
\details{
For more details about the estimator \eqn{\hat{t}} and the computation of the confidence intervals see \link{pareto_tail}.
}
\examples{
\donttest{
x <- actuar::rpareto1(1e3, shape=1, min=1)
pareto_tailplot(x, method="unbiased", xscale="o")
}

}
\references{
Klar, B. (2024). A Pareto tail plot without moment restrictions. \emph{The American Statistician}. \doi{https://doi.org/10.1080/00031305.2024.2413081}
}
