% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternaryplot.R
\name{panel.ternaryplot.response}
\alias{panel.ternaryplot.response}
\title{Response Panels for Ternary Plots}
\usage{
panel.ternaryplot.response(
  x,
  y,
  z,
  subscripts,
  response,
  region = TRUE,
  contour = TRUE,
  labels = isTRUE(contour),
  fun = c("glm", "lm"),
  formula = response ~ poly(x, y),
  ...
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{z}{Numeric vector}

\item{subscripts}{See \code{\link[lattice:panel.xyplot]{lattice::panel.xyplot()}}.}

\item{response}{An optional response variable}

\item{region}{Fill density or response estimates with a color gradient.}

\item{contour}{Draw contour lines for density and response estimates.}

\item{labels}{Label contour lines.}

\item{fun}{Function to apply to the response variable.}

\item{formula}{Formula for the function.}

\item{...}{Arguments passed on to \code{\link[lattice:llines]{lattice::panel.lines()}},
\code{\link[lattice:llines]{lattice::panel.polygon()}}, \code{\link[lattice:llines]{lattice::panel.text()}}.}
}
\value{
Plots a layer inside a panel of a \code{lattice} plot.
}
\description{
Response Panels for Ternary Plots
}
