% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternaryplot.R
\name{panel.ternaryplot}
\alias{panel.ternaryplot}
\title{Panel Function for Ternary Plots}
\usage{
panel.ternaryplot(
  x,
  y,
  z,
  subscripts,
  response = NULL,
  density = FALSE,
  region = density || !is.null(response),
  contour = density || !is.null(response),
  labels = !is.null(response),
  points = TRUE,
  grid = TRUE,
  density_breaks = NULL,
  xlab,
  ylab,
  zlab,
  xlab.default,
  ylab.default,
  zlab.default,
  ...
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{z}{Numeric vector}

\item{subscripts}{See \code{\link[lattice:panel.xyplot]{lattice::panel.xyplot()}}.}

\item{response}{An optional response variable}

\item{density}{Compute two-dimensional density estimates via \code{\link[MASS:kde2d]{MASS::kde2d()}}.}

\item{region}{Fill density or response estimates with a color gradient.}

\item{contour}{Draw contour lines for density and response estimates.}

\item{labels}{Label contour lines.}

\item{points}{Draw points (via \code{\link[=panel.ternaryplot.xyplot]{panel.ternaryplot.xyplot()}}).}

\item{grid}{Draw a reference grid.}

\item{density_breaks}{Breaks for the density plot if used (see
\code{\link[=panel.ternaryplot.density]{panel.ternaryplot.density()}}).}

\item{xlab}{X axis label (the left dimension)}

\item{ylab}{Y axis label (the right dimension)}

\item{zlab}{Z axis label (the top dimension)}

\item{xlab.default}{Internal argument}

\item{ylab.default}{Internal argument}

\item{zlab.default}{Internal argument}

\item{...}{Arguments passed down to subsequent panel functions.}
}
\value{
Plots a layer inside a panel of a \code{lattice} plot.
}
\description{
Panel Function for Ternary Plots
}
\seealso{
The building blocks of this function are available as the separate
panel functions \code{\link[=panel.ternaryplot.xyplot]{panel.ternaryplot.xyplot()}}, \code{\link[=panel.ternaryplot.grid]{panel.ternaryplot.grid()}},
\code{\link[=panel.ternaryplot.scales]{panel.ternaryplot.scales()}}, \code{\link[=panel.ternaryplot.clip]{panel.ternaryplot.clip()}},
\code{\link[=panel.ternaryplot.response]{panel.ternaryplot.response()}}, and \code{\link[=panel.ternaryplot.density]{panel.ternaryplot.density()}} in case
the user would like to get complete control of the customization.
}
