% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLC.R
\name{predict.MLC.model}
\alias{predict.MLC.model}
\title{Predict function for MLC.model-class}
\usage{
\method{predict}{MLC.model}(object, x = NULL, likelihood = FALSE, ...)
}
\arguments{
\item{object}{\code{\link[tabularMLC]{MLC.model-class}} model class to use for prediction}

\item{x}{data.frame. The feature vector to predict}

\item{likelihood}{logical. Whether to return or not the likelihood values, default FALSE.}

\item{...}{inherited from generic function (not in use)}
}
\value{
a factor vector with the predicted value. If
likelihood is TRUE, then it will also return the calculated likelihoods.
}
\description{
\code{predict} is inherited from the generic function for predictions from the results.
}
\examples{
data(iris)

n = length(iris$Species)

# Split training by sample
training = sample(1:n, size=n*0.7)
validation = (1:n)[-training]

# Train model with training dataset
mlcModel = MLC(Species ~ ., iris[training,])

# Predict using validation dataset
predict = predict(mlcModel, iris[validation,])

# Print confusion matrix
confusionMatrix = table(predicted=predict, observed=iris$Species[validation])
print(confusionMatrix)

}
