% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoxdiagnostics.R
\name{ggcoxdiagnostics}
\alias{ggcoxdiagnostics}
\title{Diagnostic Plots for Cox Proportional Hazards Model with ggplot2}
\usage{
ggcoxdiagnostics(
  fit,
  type = c("martingale", "deviance", "score", "schoenfeld", "dfbeta", "dfbetas",
    "scaledsch", "partial"),
  ...,
  linear.predictions = type \%in\% c("martingale", "deviance"),
  ox.scale = ifelse(linear.predictions, "linear.predictions", "observation.id"),
  hline = TRUE,
  sline = TRUE,
  sline.se = TRUE,
  hline.col = "red",
  hline.size = 1,
  hline.alpha = 1,
  hline.yintercept = 0,
  hline.lty = "dashed",
  sline.col = "blue",
  sline.size = 1,
  sline.alpha = 0.3,
  sline.lty = "dashed",
  point.col = "black",
  point.size = 1,
  point.shape = 19,
  point.alpha = 1,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ggtheme = ggplot2::theme_bw()
)
}
\arguments{
\item{fit}{an object of class \link[survival]{coxph.object} - created with \link[survival]{coxph} function.}

\item{type}{the type of residuals to present on Y axis of a diagnostic plot.
The same as in \link[survival]{residuals.coxph}: character string indicating the type of
residual desired. Possible values are \code{"martingale", "deviance", "score", "schoenfeld", "dfbeta", "dfbetas"}
and \code{"scaledsch"}. Only enough of the string to
determine a unique match is required.}

\item{...}{further arguments passed to \code{\link[survival]{residuals.coxph}} or
to the function \code{\link[ggpubr]{ggpar}} for customizing the plot.}

\item{linear.predictions}{(deprecated, see \code{ox.scale}) a logical value indicating whether to show linear
predictions for observations (\code{TRUE}) or just indexed of observations
(\code{FALSE}) on X axis.}

\item{ox.scale}{one value from \code{c("linear.predictions", "observation.id", "time")}.
It defines what will be presented on OX scale. Possible values: y hat for \code{"linear.predictions"},
Id of an observation for \code{"observation.id"} or Time for \code{"time"}.}

\item{hline}{a logical - should the horizontal line be added to highlight the \code{Y=0} level.}

\item{sline, sline.se}{a logical - should the smooth line be added to highlight the local average for residuals.}

\item{hline.col, hline.size, hline.lty, hline.alpha, hline.yintercept}{color, size, linetype, visibility and Y-axis coordinate to be used for \link[ggplot2]{geom_hline}.
Used only when \code{hline = TRUE}.}

\item{sline.col, sline.size, sline.lty, sline.alpha}{color, size, linetype and visibility to be used for \link[ggplot2]{geom_smooth}.
Used only when \code{sline = TRUE}.}

\item{point.col, point.size, point.shape, point.alpha}{color, size, shape and visibility to be used for points.}

\item{title, subtitle, caption}{main title, subtitle and caption.}

\item{ggtheme}{function, ggplot2 theme name. Default value is ggplot2::theme_bw().
Allowed values include ggplot2 official themes: see \code{\link[ggplot2]{theme}}.}
}
\value{
Returns an object of class \code{ggplot}.
}
\description{
Displays diagnostics graphs presenting goodness of Cox Proportional Hazards Model fit, that
can be calculated with \link[survival]{coxph} function.
}
\section{Functions}{
\itemize{
\item \code{ggcoxdiagnostics()}: Diagnostic Plots for Cox Proportional Hazards Model with \pkg{ggplot2}

}}
\examples{

library(survival)
coxph.fit2 <- coxph(Surv(futime, fustat) ~ age + ecog.ps, data=ovarian)
ggcoxdiagnostics(coxph.fit2, type = "deviance")

ggcoxdiagnostics(coxph.fit2, type = "schoenfeld", title = "Diagnostic plot")
ggcoxdiagnostics(coxph.fit2, type = "deviance", ox.scale = "time")
ggcoxdiagnostics(coxph.fit2, type = "schoenfeld", ox.scale = "time",
                 title = "Diagnostic plot", subtitle = "Data comes from survey XYZ",
                 font.subtitle = 9)
ggcoxdiagnostics(coxph.fit2, type = "deviance", ox.scale = "linear.predictions",
                 caption = "Code is available here - link", font.caption = 10)
ggcoxdiagnostics(coxph.fit2, type = "schoenfeld", ox.scale = "observation.id")
ggcoxdiagnostics(coxph.fit2, type = "scaledsch", ox.scale = "time")

}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
