% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sd_add_page}
\alias{sd_add_page}
\title{Add a Page Template to the Current Document}
\usage{
sd_add_page(page_id = "page_id")
}
\arguments{
\item{page_id}{A character string specifying the ID for the page.
Defaults to "page_id".}
}
\value{
This function does not return a value. It modifies the active
document as a side effect by inserting text and potentially removing a
function call.
}
\description{
This function inserts a template for a surveydown page at the current cursor
position in the active RStudio document. It provides a basic structure for a
new page, including a title, content area, and a next button. If the
function call exists in the document, it will be removed before inserting
the template.
}
\details{
IMPORTANT: This function should be run outside any division or R code chunk
in your 'Quarto' document. Running it inside a division or code chunk may
result in an incorrect page structure.

The function performs the following steps:
\enumerate{
\item Checks for and removes any existing \code{sd_add_page()} function call in the document.
\item Inserts a template at the current cursor position.
}

The template includes:
\itemize{
\item A div with class \code{'sd-page'} and the specified page ID
\item A placeholder for the page title
\item A placeholder for page contents
\item An R code chunk with a placeholder for questions and a next button
}

Special page_id values:
\itemize{
\item When page_id is "end", a thank-you page template with \code{sd_close()} is inserted
}
}
\examples{
if (interactive()) {
  library(surveydown)

  # Insert a new page template with default ID
  sd_add_page()

  # Insert a new page template with custom ID
  sd_add_page(page_id = "welcome")

  # Insert an end/thank you page
  sd_add_page(page_id = "end")
}

}
