% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offspring_distributions.R
\name{dpoislnorm}
\alias{dpoislnorm}
\title{Density of the Poisson-lognormal compound distribution}
\usage{
dpoislnorm(x, meanlog, sdlog)
}
\arguments{
\item{x}{A \code{number} for the quantile of the distribution.}

\item{meanlog}{A \code{number} for the mean of the distribution on the log scale.}

\item{sdlog}{A \code{number} for the standard deviation of the distribution on
the log scale.}
}
\value{
A \code{numeric} vector of the density of the Poisson-lognormal
distribution.
}
\description{
Density of the Poisson-lognormal compound distribution
}
\details{
The function is vectorised so a vector of quantiles can be input and the
output will have an equal length.
}
\examples{
dpoislnorm(x = 10, meanlog = 1, sdlog = 2)
dpoislnorm(x = 1:10, meanlog = 1, sdlog = 2)
}
