% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_dates.R
\name{eval_dates}
\alias{eval_dates}
\title{Evaluate completeness of dates}
\usage{
eval_dates(dates, rec_start, rec_end, by = "day")
}
\arguments{
\item{dates}{A vector of dates to be evaluated. Must be of class 'Date'.}

\item{rec_start}{The start date of the recording period. Must be of class 'Date'.}

\item{rec_end}{The end date of the recording period. Must be of class 'Date'.}

\item{by}{A character string specifying the time period for aggregation. One of "day", "week",
"month", "quarter", or "year". Default is "day".}
}
\value{
A data.frame with one row and two columns:
\tabular{lll}{
\strong{Name} \tab \strong{Type} \tab \strong{Description} \cr
pct_complete \tab numeric \tab Percent coverage of the \code{dates} \cr
n_miss \tab integer \tab Number of missing time periods \cr
}
}
\description{
Evaluate the completeness of a sequence of dates compared to a hypothetically complete record of
dates. \code{eval_dates()} will aggregate the dates by different time periods such as day, week,
month, quarter, or year. Intended to be used on a water quality record.
}
\examples{
dates <- seq.Date(as.Date("2020-01-01"), as.Date("2020-12-31"), by = "day")
rec_start <- as.Date("2020-01-01")
rec_end <- as.Date("2020-12-31")

# Evaluate by day
eval_dates(dates, rec_start, rec_end, by = "day")

# Evaluate by week
eval_dates(dates, rec_start, rec_end, by = "week")

# Evaluate by month
eval_dates(dates, rec_start, rec_end, by = "month")

# Evaluate by quarter
eval_dates(dates, rec_start, rec_end, by = "quarter")

# Evaluate by year
eval_dates(dates, rec_start, rec_end, by = "year")

# Example with missing dates
dates_with_na <- dates
dates_with_na[c(10, 20, 30)] <- NA
eval_dates(dates_with_na, rec_start, rec_end, by = "day")
}
