% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STLFinhom.R
\name{STLFinhom}
\alias{STLFinhom}
\title{Inhomogeneous empty space function for spatio-temporal  point processes on linear networks}
\usage{
STLFinhom(X,
lambda = NULL,
r = NULL,
t = NULL,
nxy = 10,
dimt = 10,
dimyx = 12)
}
\arguments{
\item{X}{a spatio-temporal point pattern of class \code{\link{stlpp}}}

\item{lambda}{values of estimated intensity at data points}

\item{r}{values of argument r where pair correlation function will be evaluated. optional}

\item{t}{values of argument t where pair correlation function will be evaluated. optional}

\item{nxy}{pixel array dimensions. optional}

\item{dimt}{description}

\item{dimyx}{description}
}
\value{
An object of class \code{sumstlpp}.
}
\description{
This function computes the inhomogeneous empty space function for spatio-temporal  point patterns on linear networks.
}
\details{
This function calculates the inhomogeneous empty space function for a spatio-temporal point patterns on a linear network.
}
\examples{
\dontrun{
X <- rpoistlpp(.2,a=0,b=5,L=easynet)
lambda <- density(X,at="points")
k <- STLKinhom(X,lambda=lambda,normalize=TRUE)
plot(k)
}

}
\references{
Moradi, M., & Sharifi, A. (2024). Summary statistics for spatio-temporal point processes on linear networks. Spatial Statistics, 61, 100840.
}
\seealso{
\code{\link{STLJinhom}}, \code{\link{STLHinhom}}, \code{\link{STLKinhom}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
