% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_dbl.R, R/to_dbl.R
\name{stabilize_dbl}
\alias{stabilize_dbl}
\alias{stabilize_dbl_scalar}
\alias{to_dbl}
\alias{to_dbl.NULL}
\alias{to_dbl.character}
\alias{to_dbl.factor}
\alias{to_dbl_scalar}
\title{Ensure a double argument meets expectations}
\usage{
stabilize_dbl(
  x,
  ...,
  allow_null = TRUE,
  allow_na = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  min_size = NULL,
  max_size = NULL,
  min_value = NULL,
  max_value = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

stabilize_dbl_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  min_value = NULL,
  max_value = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_dbl(
  x,
  ...,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

\method{to_dbl}{`NULL`}(x, ..., allow_null = TRUE, x_arg = caller_arg(x), call = caller_env())

\method{to_dbl}{character}(
  x,
  ...,
  coerce_character = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

\method{to_dbl}{factor}(
  x,
  ...,
  coerce_factor = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_dbl_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{...}{Arguments passed to methods.}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{allow_na}{\verb{(length-1 logical)} Are NA values ok?}

\item{coerce_character}{\verb{(length-1 logical)} Should character vectors such as
"1" and "2.0" be considered numeric-ish?}

\item{coerce_factor}{\verb{(length-1 logical)} Should factors with values such as
"1" and "2.0" be considered numeric-ish? Note that this package uses the
character value from the factor, while \code{\link[=as.integer]{as.integer()}} and \code{\link[=as.double]{as.double()}} use
the integer index of the factor.}

\item{min_size}{\verb{(length-1 integer)} The minimum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{\verb{(length-1 integer)} The maximum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{min_value}{\verb{(length-1 numeric)} The lowest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{max_value}{\verb{(length-1 numeric)} The highest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}

\item{allow_zero_length}{\verb{(length-1 logical)} Are zero-length vectors
acceptable?}
}
\value{
The argument as a double.
}
\description{
\code{to_dbl()} checks whether an argument can be coerced to double
without losing information, returning it silently if so. Otherwise an
informative error message is signaled.

\code{stabilize_dbl()} can check more details about the argument, but is slower
than \code{to_dbl()}.

\code{stabilize_dbl_scalar()} and \code{to_dbl_scalar()} are optimized to check for
length-1 double vectors.
}
\examples{
to_dbl(1:10)
to_dbl("1.1")
to_dbl(1 + 0i)
to_dbl(NULL)
try(to_dbl("a"))
try(to_dbl("1.1", coerce_character = FALSE))

to_dbl_scalar("1.1")
try(to_dbl_scalar(1:10))

stabilize_dbl(1:10)
stabilize_dbl("1.1")
stabilize_dbl(1 + 0i)
stabilize_dbl(NULL)
try(stabilize_dbl(NULL, allow_null = FALSE))
try(stabilize_dbl(c(1.1, NA), allow_na = FALSE))
try(stabilize_dbl(letters))
try(stabilize_dbl("1.1", coerce_character = FALSE))
try(stabilize_dbl(factor(c("1.1", "a"))))
try(stabilize_dbl(factor("1.1"), coerce_factor = FALSE))
try(stabilize_dbl(1:10, min_value = 3.5))
try(stabilize_dbl(1:10, max_value = 7.5))

stabilize_dbl_scalar(1.0)
stabilize_dbl_scalar("1.1")
try(stabilize_dbl_scalar(1:10))
stabilize_dbl_scalar(NULL)
try(stabilize_dbl_scalar(NULL, allow_null = FALSE))
}
