% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_chr.R, R/to_chr.R
\name{stabilize_chr}
\alias{stabilize_chr}
\alias{stabilize_chr_scalar}
\alias{to_chr}
\alias{to_chr.NULL}
\alias{to_chr_scalar}
\title{Ensure a character argument meets expectations}
\usage{
stabilize_chr(
  x,
  ...,
  allow_null = TRUE,
  allow_na = TRUE,
  min_size = NULL,
  max_size = NULL,
  regex = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

stabilize_chr_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  regex = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_chr(
  x,
  ...,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

\method{to_chr}{`NULL`}(x, ..., allow_null = TRUE, x_arg = caller_arg(x), call = caller_env())

to_chr_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{...}{Arguments passed to methods.}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{allow_na}{\verb{(length-1 logical)} Are NA values ok?}

\item{min_size}{\verb{(length-1 integer)} The minimum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{\verb{(length-1 integer)} The maximum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{regex}{\verb{(character, list, or stringr_pattern)} One or more optional
regular expressions to test against the values of \code{x}. This can be a
character vector, a list of character vectors, or a pattern object from the
\{stringr\} package (e.g., \code{stringr::fixed("a.b")}). The default error
message for non-matching values will include the pattern itself (see
\code{\link[=regex_must_match]{regex_must_match()}}). To provide a custom message, supply a named
character vector where the value is the regex pattern and the name is the
message that should be displayed. To check that a pattern is \emph{not} matched,
attach a \code{negate} attribute set to \code{TRUE}. If a complex regex pattern
throws an error, try installing the stringi package.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}

\item{allow_zero_length}{\verb{(length-1 logical)} Are zero-length vectors
acceptable?}
}
\value{
The argument as a character vector.
}
\description{
\code{to_chr()} checks whether an argument can be coerced to
character without losing information, returning it silently if so.
Otherwise an informative error message is signaled.

\code{stabilize_chr()} can check more details about the argument, but is slower
than \code{to_chr()}.

\code{stabilize_chr_scalar()} and \code{to_chr_scalar()} are optimized to check for
length-1 character vectors.
}
\details{
These functions have two important differences from
\code{\link[base:character]{base::as.character()}}:
\itemize{
\item \code{list}s and \code{data.frame}s are \emph{not} coerced to character. In base R, such
objects are coerced to character representations of their elements. For
example, \code{as.character(list(1:3))} returns "1:10". In the unlikely event
that this is the expected behavior, use \code{as.character()} instead.
\item \code{NULL} values can be rejected as part of the call to this function (with
\code{allow_null = FALSE}).
}
}
\examples{
to_chr("a")
to_chr(letters)
to_chr(1:10)
to_chr(1 + 0i)
to_chr(NULL)
try(to_chr(NULL, allow_null = FALSE))

to_chr_scalar("a")
try(to_chr_scalar(letters))

stabilize_chr(letters)
stabilize_chr(1:10)
stabilize_chr(NULL)
try(stabilize_chr(NULL, allow_null = FALSE))
try(stabilize_chr(c("a", NA), allow_na = FALSE))
try(stabilize_chr(letters, min_size = 50))
try(stabilize_chr(letters, max_size = 20))
try(stabilize_chr(c("hide", "find", "find", "hide"), regex = "hide"))

stabilize_chr_scalar(TRUE)
stabilize_chr_scalar("TRUE")
try(stabilize_chr_scalar(c(TRUE, FALSE, TRUE)))
stabilize_chr_scalar(NULL)
try(stabilize_chr_scalar(NULL, allow_null = FALSE))
}
