% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SScousens85.R
\name{SScousens85}
\alias{SScousens85}
\alias{cousens85.fun}
\alias{NLS.cousens85}
\alias{DRC.cousens85}
\title{Rectangular hyperbola for yield/weed density relationship}
\usage{
cousens85.fun(predictor, Ywf, i, A)
NLS.cousens85(predictor, Ywf, i, A)
DRC.cousens85(fixed = c(NA, NA, NA), names = c("Ywf", "i", "A"))
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model}

\item{Ywf}{model parameter (Weed-free yield)}

\item{i}{model parameter (initial slope)}

\item{A}{model parameter (maximum percentage yield loss)}

\item{fixed}{numeric vector. Specifies which parameters are fixed and at what value they are fixed. NAs for parameter that are not fixed.}

\item{names}{a vector of character strings giving the names of the parameters. The default is usually reasonable.}
}
\value{
cousens85.fun, NLS.cousens85 return a numeric value,
while DRC.cousens85 return a list containing the nonlinear function
and the self starter function
}
\description{
These functions provide the rectangula hyperbola that was devided by Cousens (1985)
for modelling the relationship between crop yield and weed density. The function was
derived from the yield-loss function, and contains parameters that are revelant for
competition studies. These functions provide the
equation (cousens85.fun), the self-starters for the \code{\link{nls}}
function (NLS.cousens85) and the self-starters for
the \code{\link[drc]{drm}} function in the drc package (DRC.cousens85)
}
\details{
This equation is parameterised as:
\deqn{ f(x) = Ywf \, \frac{(1 - (i predictor)} {(100 \, (1 + i \, predictor/A)))} }
It depicts a decreasing curve with no inflection point. The curve is equal
to 'Ywf' when x = 0 and the lower asymptote is at 'A' multiplied by 'Ywf/100'
}
\examples{
library(statforbiology)
dataset <- getAgroData("Sinapis")

# nls fit
mod.nls <- nls(yield ~ NLS.cousens85(density, Ywf, i, A),
               data = dataset )
summary(mod.nls)
mod.nls2 <- drm(yield ~ density, fct = DRC.cousens85(), data = dataset )
summary(mod.nls2)
plot(mod.nls2)

}
\references{
Ratkowsky, DA (1990) Handbook of nonlinear regression models. New York (USA): Marcel Dekker Inc.

Onofri, A. (2020). A collection of self-starters for nonlinear regression in R. See: \url{https://www.statforbiology.com/2020/stat_nls_usefulfunctions/}

Cousens, R., 1985. A simple model relating yield loss to weed density. Annals of Applied Biology 107, 239–252. https://doi.org/10.1111/j.1744-7348.1985.tb01567.x
}
\author{
Andrea Onofri
}
