% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_check.R
\name{eem_checkdata}
\alias{eem_checkdata}
\title{Check your EEM, absorption and metadata before processing}
\usage{
eem_checkdata(
  eem_list,
  absorbance,
  metadata = NULL,
  metacolumns = NULL,
  correction = FALSE,
  error = TRUE
)
}
\arguments{
\item{eem_list}{eemlist continaing EEM data.}

\item{absorbance}{data.frame containing absorbance data.}

\item{metadata}{optional data.frame containing metadata.}

\item{metacolumns}{character vector of columns that are checkt for complete data sets}

\item{correction}{logical, whether EEMs should be checked for applied corrections}

\item{error}{logical, whether a problem should cause an error or not.}
}
\value{
writes out possible porblems to command line, additionally list with sample names where possible problems were found, see details.
}
\description{
The function tries to lead you to possible problems in your data.
}
\details{
The returned list contains character vectors with sample names where possible problems were found: problem (logical, whether a severe problem was found), nas (sample names with NAs in EEM data), missing_correction (correction of EEM samples was not done or not done successfully),eem_no_abs (EEM samples with no absorbance data), abs_no_eem (samples with present absorbance but no EEM data), duplse (duplicate sample names in EEM data), duplsa (duplicate sample names in absorbance data), invalid_eem (invalid EEM sample name), invalid_abs (invalid absorbance sample name), range_mismatch (wavelength ranges of EEM and absorbance data are mismatching), metadupls (duplicate sample names in metadata), metamissing (EEM samples where metadata is missing), metaadd (samples in metadata without EEM data)
}
\examples{
folder <- system.file("extdata/EEMs", package = "staRdom") # load example data
eem_list <- eem_read(folder, recursive = TRUE, import_function = eem_csv)

abs_folder <- system.file("extdata/absorbance", package = "staRdom") # load example data
absorbance <- absorbance_read(abs_folder, cores = 2)

metatable <- system.file("extdata/metatable_dreem.csv",package = "staRdom")
meta <- read.table(metatable, header = TRUE, sep = ",", dec = ".", row.names = 1)

checked <- eem_checkdata(eem_list, absorbance, metadata = meta,
metacolumns = "dilution", error = FALSE)
# This example returns a message, that absorbance data for the
# blank samples are missing. As absorbance is supposed to be 0 over
# the whole spectrum when you measure blanks, there is no need
# to supply the data and do an inner-filter effect correction.
}
