% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterFactuals.R
\name{get_mu_yt}
\alias{get_mu_yt}
\title{Compute the conditional mean \eqn{\mu_{y,t}=\phi_{y,t} + \sum_{i=1}^pA_{y,t,i}y_{t-i}} for a single time period}
\usage{
get_mu_yt(phi_yt, all_A_yti, bold_y_t_minus_1)
}
\arguments{
\item{phi_yt}{a \eqn{(d \times M)} matrix such that the \eqn{m}th column contains the intercept parameters of the \eqn{m}th regime.}

\item{all_A_yti}{a 3D array containing the coefficient matrices for the given time period so that the lag \eqn{i} coefficient matrix
\eqn{A_{y,t,i}} can be obtained by choosing \code{[, , i]}.}

\item{bold_y_t_minus_1}{a \eqn{(dp \times 1)} vector \eqn{\boldsymbol{y}_{t-1}=(y_{t-1},...,y_{t-p})} containing the lagged observations
for the time period \eqn{t}.}
}
\value{
Returns the \eqn{(d \times 1)} vector of the conditional mean for the time period \eqn{t}.
}
\description{
\code{get_mu_yt} computes the conditional mean \eqn{\mu_{y,t}=\phi_{y,t} + \sum_{i=1}^pA_{y,t,i}y_{t-i}} for a single time period
 based on the intercepts, AR matrices, and the vector of lagged observations.
}
\details{
This is used in simulation of the counterfactual scenarios.
}
\keyword{internal}
