% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterFactuals.R
\name{get_allA_yti}
\alias{get_allA_yti}
\title{Compute the autoregression matrices \eqn{A_{y,t,i}\equiv \sum_{m=1}^M\alpha_{m,t}A_{m,i}} for all lags \eqn{i=1,...,p}
 for a single time period}
\usage{
get_allA_yti(all_A, alpha_mt)
}
\arguments{
\item{all_A}{4D array containing the coefficient matrices of all regimes so that coefficient matrix
\eqn{A_{m,i}} can be obtained by choosing \code{[, , i, m]} (as obtained from \code{pick_allA}).}

\item{alpha_mt}{an \eqn{(M \times 1)} vector containing the time period \eqn{t} transition weights.}
}
\value{
Returns the 3D array containing the coefficient matrices for the given time period so that the lag \eqn{i} coefficient matrix \eqn{A_{y,t,i}}
can be obtained by choosing \code{[, , i]}.
}
\description{
\code{get_allA_yti} computes the autoregression matrices \eqn{A_{y,t,i}\equiv \sum_{m=1}^M\alpha_{m,t}A_{m,i}}, for all lags \eqn{i=1,...,p}
 for a single time period, based on the regime autoregression matrices and transition weights.
}
\details{
This is used in simulation of the counterfactual scenarios.
}
\keyword{internal}
