% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cstep}
\alias{cstep}
\title{Perform Concentration Step}
\usage{
cstep(init, maxcsteps, which_indices, lambda, weights, mT)
}
\arguments{
\item{init}{A list of items where each item contains:
\itemize{
  \item \code{mX} A matrix of observations (one column per observation).
  \item \code{hsets.init} A matrix where each column specifies initial indices for neighbors.
  \item \code{rho} A regularization parameter for covariance estimation.
  \item \code{scfac} A scaling factor for consistency.
  \item \code{mS} A covariance matrix of the observations in \code{mX}.
  \item \code{index} (Initially not present; will be updated with indices of neighbors).
  \item \code{vdst} (Initially not present; will be updated with Mahalanobis distances).
  \item \code{stop} (Initially not present; used to indicate convergence).
  \item \code{ret} (Initially not present; will be updated with results from \code{RCOV}).
}}

\item{maxcsteps}{An integer specifying the maximum number of iterations for the optimization.}

\item{which_indices}{An integer vector specifying which initial indices to use for each item.}

\item{lambda}{A numeric value representing the weight for the covariance matrix in the optimization.}

\item{weights}{A matrix of weights where each element \code{weights(i, j)} specifies the weight of the \code{j}-th item for the \code{i}-th item.}

\item{mT}{A matrix used for regularization in the covariance matrix calculation.}
}
\value{
A list containing:
  \itemize{
    \item \code{numit} An integer representing the number of iterations performed.
    \item \code{out} The updated list of items with updated neighborhoods and additional information.
    \item \code{obj_value} A numeric vector of objective values at each iteration, including the initial value.
  }
}
\description{
This function performs concentration steps by iteratively updating
the neighborhoods of items based on Mahalanobis distances. The function computes
the covariance matrix and updates the neighborhood list until convergence or
a maximum number of iterations is reached.
}
\details{
The function updates the neighborhoods of each item based on Mahalanobis distances, recalculates means and covariances,
and checks for convergence. If the neighborhoods do not change between iterations, the optimization stops early.
}
\keyword{internal}
