testthat::context("Query class")

testthat::test_that("Constructor works fine", {
  testthat::expect_error(Query$new())
  query <- Query$new("Limit?")
  testthat::expect_equal(query$toString(), ";")
})

testthat::test_that("We can use one single statement", {
  testthat::expect_error(Query$new())
  query <- Query$new("Limit")
  query$add(StmtLimit$new(10))
  testthat::expect_equal(query$toString(), "LIMIT 10;")
})

testthat::test_that("An error is thrown on a wrong statement", {
  query <- Query$new("Limit")
  testthat::expect_error(query$add(ExprValue$new(10)))
})

testthat::test_that("An error is thrown on missing statement", {
  query <- Query$new("Limit")
  testthat::expect_error(query$toString())
})

testthat::test_that("An error is thrown on duplicated statement", {
  query <- Query$new("Limit")
  query$add(StmtLimit$new(10))
  testthat::expect_error(query$add(StmtLimit$new(20)))
})

testthat::test_that(paste("An error in thrown when a statement's class",
                          "matches multiple allowed classes"), {
  StmtA <- R6::R6Class("StmtA", inherit = Statement)
  StmtB <- R6::R6Class("StmtB", inherit = StmtA)
  my_query <- Query$new(c("A", "B"))
  x <- StmtB$new()
  testthat::expect_error(my_query$add(x))
})
