% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StmtJoin.R
\name{StmtJoin}
\alias{StmtJoin}
\title{SQL JOIN statement.}
\description{
SQL JOIN statement.

SQL JOIN statement.
}
\details{
This class represents a SQL JOIN statement. It requires two fields on which
to join, and the type of join to perform (inner, left, right, or full).
The table on which to join is determined by looking at the two fields in
order and using the first table name available.
}
\examples{
# Create an inner join (default join type) between table 'foo' and table
# 'bar':
join <- StmtJoin$new(ExprField$new("id", "foo"),
                     ExprField$new("foo_id", "bar"))

# Create a left join between table 'foo' and table 'bar':
join <- StmtJoin$new(ExprField$new("id", "foo"),
                     ExprField$new("foo_id", "bar"),
                     type = "left")

}
\section{Super class}{
\code{\link[sqlq:Statement]{sqlq::Statement}} -> \code{StmtJoin}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StmtJoin-new}{\code{StmtJoin$new()}}
\item \href{#method-StmtJoin-getTokens}{\code{StmtJoin$getTokens()}}
\item \href{#method-StmtJoin-clone}{\code{StmtJoin$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Statement" data-id="toString"><a href='../../sqlq/html/Statement.html#method-Statement-toString'><code>sqlq::Statement$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtJoin-new"></a>}}
\if{latex}{\out{\hypertarget{method-StmtJoin-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
To determine the table on which to join, we look at the both fields in
order and use the first table name available.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtJoin$new(field1, field2, type = c("inner", "left", "right", "full"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field1}}{The first field on which to join.}

\item{\code{field2}}{The second field on which to join.}

\item{\code{type}}{The type of join to perform. One of "inner", "left", "right",
or "full". Defaults to "inner".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtJoin-getTokens"></a>}}
\if{latex}{\out{\hypertarget{method-StmtJoin-getTokens}{}}}
\subsection{Method \code{getTokens()}}{
Generates the list of tokens representing this statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtJoin$getTokens()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of Token objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtJoin-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StmtJoin-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtJoin$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
