#' Create query.
#'
#' This class represents an SQL CREATE TABLE query.
#' See the function make_create_table() to create more easily a QueryCreate
#' object.
#'
#' @examples
#' # To generate the CREATE query for creating a simple table for listing books:
#' fields_def <- list(ExprFieldDef$new('id', 'integer', primary=TRUE),
#'                    ExprFieldDef$new('title', 'varchar(200)', nullable=FALSE),
#'                    ExprFieldDef$new('author', 'varchar(80)', nullable=FALSE))
#' create <- QueryCreate$new(StmtCreate$new(tabl = 'books',
#'                                          fields_def = fields_def))
#'
#' @seealso \code{\link{make_create_table}}
#' @import R6
#' @include Query.R
#' @export
QueryCreate <- R6::R6Class("QueryCreate",
  inherit = Query,
  public = list(

    #' @description
    #' Initializer.
    #' @param create A StmtCreate instance.
    #' @return Nothing.
    initialize = function(create) {
      chk::chk_is(create, "StmtCreate")
      super$initialize("Create")
      self$add(create)
      return(invisible(NULL))
    }
  )
)
