% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.spsur.R
\name{summary.spsur}
\alias{summary.spsur}
\title{Summary of estimated objects of class \emph{spsur}.}
\usage{
\method{summary}{spsur}(object, ...)
}
\arguments{
\item{object}{An \emph{spsur} object estimated using \code{\link{spsurml}},
\code{\link{spsur3sls}} or \code{\link{spsurtime}} functions.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \emph{summary.spsur}
}
\description{
This function summarizes estimated \emph{spsur} objects. The tables in the output
 include basic information for each equation. The report also shows other complementary results
 corresponding to the SUR model like the \emph{(GxG)} covariance matrix of the residuals of the
 equations of the SUR, the estimated log-likelihood, the Breusch-Pagan diagonality test or the Marginal
 Lagrange Multiplier, LMM, tests of spatial dependence.
}
\examples{
 # See examples for \code{\link{spsurml}} or
 # \code{\link{spsur3sls}} functions.

}
\seealso{
\code{\link{print.summary.spsur}}; \code{\link{spsurml}}; \code{\link{spsur3sls}}.
}
\author{
\tabular{ll}{
  Fernando Lopez  \tab \email{fernando.lopez@upct.es} \cr
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Jesus Mur  \tab \email{jmur@unizar.es} \cr
  }
}
