% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/css_loader.R
\name{cssLoader}
\alias{cssLoader}
\title{Create a variety of CSS loaders on UI}
\usage{
cssLoader(
  type = "default",
  src = "",
  id = "",
  height = "1.5rem",
  width = height,
  color = "#337ab7",
  opacity = 1,
  inline = FALSE,
  is_icon = FALSE,
  ...
)
}
\arguments{
\item{type}{string, one of  "circle", "dual-ring", "facebook", "heart",
"ring", "roller", "default", "ellipsis", "grid", "hourglass", "ripple",
"spinner", "gif", default is "default".}

\item{src}{string, online URL or local path of the gif animation file if
you would like to upload your own loader.}

\item{id}{string, optional, ID for the component, if not given, a random
ID will be given.}

\item{height}{string, pixel, like "10px"; or (r)em, "1.5rem", "1.5em".
Default is "1.5rem".}

\item{width}{string, default is the same as \code{height}. For most loader, you
want to keep width = height for a square shape.}

\item{color}{string, any valid CSS color name, or hex color code}

\item{opacity}{number, between 0-1}

\item{inline}{bool, do you want the loader be inline? This is useful to turn on if
you want to add the loader to a \link[shiny:actionButton]{shiny::actionButton}, so the loader and button
label will be on the same line. See examples.}

\item{is_icon}{bool, default uses the HTML \code{div} tag, turn on this option will
use the \code{i} tag for icon. Useful if you want to add the loader as \code{icon} argument
for the \link[shiny:actionButton]{shiny::actionButton}. See examples.}

\item{...}{other shiny tags or HTML attributes you want to add to the loader.}
}
\value{
returns a css loader component.
}
\description{
CSS loaders can improve user experience by adding a small
animation icon to a HTML element. spsComps provides you 12 different
looking CSS loaders. Unlike other Shiny packages, you have full control
of the CSS loader here, like position, color, size, opacity, etc.
}
\details{
\subsection{'rem' unit}{

For most modern web apps, including Shiny, 1rem = 10px
}
}
\examples{
if (interactive()){
  library(shiny)
  heights <- paste0(c(1.5, 3, 5, 8, 10, 15, 20), "rem")
  colors <- list(
    colorRampPalette(c("#00d2ff", "#3a7bd5"))(7),
    colorRampPalette(c("#59C173", "#a17fe0", "#5D26C1"))(7),
    colorRampPalette(c("#667db6", "#0082c8", "#5D26C1", "#667db6"))(7),
    colorRampPalette(c("#f2709c", "#ff9472"))(7),
    colorRampPalette(c("#FC5C7D", "#6A82FB"))(7),
    colorRampPalette(c("#4568DC", "#B06AB3"))(7)
  )
  types <- c("circle", "dual-ring", "facebook", "heart",
             "ring", "roller", "default", "ellipsis",
             "grid", "hourglass", "ripple", "spinner")
  ui <- fluidPage(
    lapply(seq_along(types), function(i){
      div(
        h4(types[i]), br(),
        lapply(1:7, function(x){
          cssLoader(
            types[i], height = heights[x],
            color = colors[[if(i > 6) i - 6 else i]][x],
            inline = TRUE
          )
        }),
        br()
      )
    })
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}

# use with buttons
if (interactive()){
  library(shiny)
  ui <- fluidPage(
    actionButton(
      "btn-a", "",
      ## `inline = TRUE` is important if you want loader and
      ## text in the same line.
      icon =  cssLoader(is_icon = TRUE, inline = TRUE, color = "#3a7bd5"
      )
    ),
    actionButton(
      "btn-b", "Loading",
      icon =  cssLoader(type = "hourglass", is_icon = TRUE, color = "#667db6", inline = TRUE)
    )
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
# use your own
if (interactive()){
  library(shiny)
  spinner <- "https://github.com/lz100/spsComps/blob/master/examples/demo/www/spinner.gif?raw=true"
  eater <- "https://github.com/lz100/spsComps/blob/master/examples/demo/www/bean_eater.gif?raw=true"
  ui <- fluidPage(
    cssLoader(
      "gif", spinner, height = "50px"
    ),
    cssLoader(
      "gif", spinner, height = "100px"
    ),
    cssLoader(
      "gif", eater, height = "150px"
    ),
    cssLoader(
      "gif", eater, height = "200px"
    ),
    actionButton(
      "btn-custom1", "",
      icon =  cssLoader(
        type = "gif", src = spinner,
        is_icon = TRUE, inline = TRUE
      )
    ),
    actionButton(
      "btn-custom2", "A button",
      icon =  cssLoader(
        type = "gif", src = eater,
        is_icon = TRUE, inline = TRUE
      )
    )
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
}
