% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{basis_pca}
\alias{basis_pca}
\title{The basis of Principal Component Analysis (PCA)}
\usage{
basis_pca(data, d = 2)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations.}

\item{d}{Number of dimensions in the projection space.}
}
\description{
The orthogonal linear components of the variables in the next largest
direction of variance.
}
\examples{
dat <- scale_sd(wine[, 2:6])
basis_pca(data = dat)
}
\seealso{
\code{\link[Rdimtools:do.pca]{Rdimtools::do.pca}}

Other basis producing functions: 
\code{\link{basis_guided}()},
\code{\link{basis_half_circle}()},
\code{\link{basis_odp}()},
\code{\link{basis_olda}()},
\code{\link{basis_onpp}()}
}
\concept{basis producing functions}
