% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data.R
\name{noise_gen}
\alias{noise_gen}
\title{Generate Synthetic Noise}
\usage{
noise_gen(n = 500, type = "gaussian", level = 0.01, seed = NULL)
}
\arguments{
\item{n}{Integer. Number samples to generate. Default is 500.}

\item{type}{Character string specifying the type of noise to generate. Supported types:
\itemize{
\item \code{"gaussian"}: Standard normal distribution.
\item \code{"uniform"}: Uniform distribution between -level and +level.
\item \code{"lognormal"}: Log-normal distribution.
\item \code{"t_distributed"}: Heavy-tailed t-distribution with 3 degrees of freedom.
\item \code{"cauchy"}: Extremely heavy-tailed Cauchy distribution.
\item \code{"beta_noise"}: Beta distribution shifted and scaled to \verb{[-level, level]}.
\item \code{"exponential"}: Positive-only exponential distribution.
\item \code{"microstructure"}: Oscillatory sinusoidal pattern with additive Gaussian noise.
}}

\item{level}{Numeric. Controls the scale (standard deviation, range, or spread) of the noise. Default is \code{0.01}.}

\item{seed}{Optional integer. Sets a random seed for reproducibility.}
}
\value{
A tibble with two columns:
\itemize{
\item \code{value}: Numeric vector of generated noise samples.
\item \code{type}: Character string indicating the type of noise.
}
}
\description{
Generate Synthetic Noise
}
\examples{
# Gaussian noise with small scale
noise_gen(500, type = "gaussian", level = 0.05)

# Heavy-tailed noise
noise_gen(500, type = "t_distributed", level = 0.1)

}
