% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wschisq_utils}
\alias{wschisq_utils}
\alias{r_wschisq_Cpp}
\alias{p_wschisq_MC}
\title{Utilities for weighted sums of non-central chi squared random
variables}
\usage{
r_wschisq_Cpp(n, weights, dfs, ncps)

p_wschisq_MC(x, weights = 0L, dfs = 0L, ncps = 0L, M = 10000L,
  sample = 0L, use_sample = FALSE, x_sorted = FALSE)
}
\arguments{
\item{n}{sample size.}

\item{weights}{vector with the positive weights of the sum. Must have the
same length as \code{dfs}.}

\item{dfs}{vector with the positive degrees of freedom of the chi squared
random variables. Must have the same length as \code{weights}.}

\item{ncps}{non-negative non-centrality parameters. A vector with the same
length as \code{weights}.}

\item{x}{vector of quantiles.}

\item{M}{number of Monte Carlo samples for approximating the distribution.
Defaults to \code{1e4}.}

\item{sample}{if \code{use_sample = TRUE}, the Monte Carlo sample to
approximate the distribution. If not, it is computed internally. Defaults
to \code{1e4}.}

\item{use_sample}{use the already computed \code{sample}? If \code{FALSE}
(default), \code{sample} is computed internally.}
}
\value{
\itemize{
  \item \code{r_wschisq_Cpp}: a matrix of size \code{c(n, 1)}
  containing a random sample.
  \item \code{p_wschisq_MC}: a matrix of size \code{c(nx, 1)}
  with the evaluation of the distribution function at \code{x}.
}
}
\description{
Simulation from a weighted sum of non-central chi squared
random variables and Monte Carlo approximation of its distribution function.
}
\keyword{internal}
