% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spatialreghp.r
\name{plot.spatialreghp}
\alias{plot.spatialreghp}
\title{Plot for a \code{\link{spatialreg.hp}} object}
\usage{
\method{plot}{spatialreghp}(x, plot.perc = FALSE, commonality = FALSE, color = NULL, dig = 4, ...)
}
\arguments{
\item{x}{A \code{\link{spatialreg.hp}} object.}

\item{plot.perc}{Logical;if TRUE, the bar plot (based on ggplot2 package) of the percentage to individual effects of variables and spatial towards total explained variation, the default is FALSE to show plot with original individual effects.}

\item{commonality}{Logical; If TRUE, the result of commonality analysis is shown, the default is FALSE.}

\item{color}{Color of variables.}

\item{dig}{Integer; number of decimal places in Venn diagram.}

\item{...}{unused}
}
\value{
a ggplot object
}
\description{
Plot for a \code{\link{spatialreg.hp}} object
}
\examples{
library(spatialreg)
library(spdep)
data(oldcol, package="spdep")
listw <- spdep::nb2listw(COL.nb, style="W")
ev <- eigenw(listw)
W <- as(listw, "CsparseMatrix")
trMatc <- trW(W, type="mult")
COL.lag.eig <- lagsarlm(CRIME ~ INC + HOVAL, data=COL.OLD, listw=listw,
method="eigen", control=list(pre_eig=ev, OrdVsign=1))
spatialreg.hp(COL.lag.eig)
spatialreg.hp(COL.lag.eig,iv=list(pre1="INC",pre2="HOVAL"))
spatialreg.hp(COL.lag.eig,iv=list(pre1="INC",pre2="HOVAL"),commonality=TRUE)
plot(spatialreg.hp(COL.lag.eig))
plot(spatialreg.hp(COL.lag.eig,commonality=TRUE),commonality=TRUE)
}
\author{
{Jiangshan Lai} \email{lai@njfu.edu.cn}
}
