% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_hof.R
\name{hof_array_sort}
\alias{hof_array_sort}
\title{Sorts array using a custom comparator}
\usage{
hof_array_sort(x, func, expr = NULL, dest_col = NULL, ...)
}
\arguments{
\item{x}{The Spark data frame to be processed}

\item{func}{The comparator function to apply (it should take 2 array elements as arguments
and return an integer, with a return value of -1 indicating the first element is less than
the second, 0 indicating equality, or 1 indicating the first element is greater than the
second)}

\item{expr}{The array being sorted, could be any SQL expression evaluating to an array
(default: the last column of the Spark data frame)}

\item{dest_col}{Column to store the sorted result (default: expr)}

\item{...}{Additional params to dplyr::mutate}
}
\description{
Applies a custom comparator function to sort an array
(this is essentially a dplyr wrapper to the `array_sort(expr, func)` higher-
order function, which is supported since Spark 3.0)
}
\examples{
\dontrun{

library(sparklyr)
sc <- spark_connect(master = "local", version = "3.0.0")
copy_to(
  sc,
  dplyr::tibble(
    # x contains 2 arrays each having elements in ascending order
    x = list(1:5, 6:10)
  )
) \%>\%
  # now each array from x gets sorted in descending order
  hof_array_sort(~ as.integer(sign(.y - .x)))
}

}
