/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import sparklyr.ArrowBatchStreamWriter;
import sparklyr.ArrowConvertersImpl;
import sparklyr.Invoke;
import sparklyr.Logger;

public final class ArrowConverters$ {
    public static final ArrowConverters$ MODULE$ = new ArrowConverters$();

    public Iterator<Row> fromPayloadArray(byte[][] records, StructType schema) {
        TaskContext$.MODULE$.get();
        ClassTag map$extension_ct = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE));
        int map$extension_len = records.length;
        Object map$extension_ys = map$extension_ct.newArray(map$extension_len);
        if (map$extension_len > 0) {
            for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                ScalaRunTime$.MODULE$.array_update(map$extension_ys, map$extension_i, (Object)records[map$extension_i]);
            }
        }
        Object var4_3 = null;
        Object var6_5 = null;
        Iterator singleRecords = ArrayOps$.MODULE$.iterator$extension((Object)((Object[])map$extension_ys));
        return new ArrowConvertersImpl().fromPayloadIterator((Iterator<byte[]>)singleRecords, (Option<TaskContext>)None$.MODULE$).map(arg_0 -> ArrowConverters$.$anonfun$fromPayloadArray$2(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)schema), arg_0));
    }

    public Dataset<byte[]> toArrowDataset(Dataset<Row> df, SparkSession sparkSession, String timeZoneId) {
        StructType schema = df.schema();
        int maxRecordsPerBatch = sparkSession.sessionState().conf().arrowMaxRecordsPerBatch();
        AgnosticEncoders.BinaryEncoder$ encoder = AgnosticEncoders.BinaryEncoder$.MODULE$;
        return df.mapPartitions((Function1 & Serializable)iter -> new ArrowConvertersImpl().toBatchIterator((Iterator<Row>)iter, schema, maxRecordsPerBatch, timeZoneId, TaskContext$.MODULE$.get()), (Encoder)encoder);
    }

    public byte[] toArrowStream(Dataset<Row> df, String timeZoneId, Iterator<byte[]> batchIter) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowBatchStreamWriter batchWriter = new ArrowBatchStreamWriter(df.schema(), out, timeZoneId);
        batchWriter.writeOneBatch(batchIter);
        batchWriter.end();
        return out.toByteArray();
    }

    public byte[] toArrowBatchRdd(Dataset<Row> df, SparkSession sparkSession, String timeZoneId) {
        byte[][] batches = (byte[][])this.toArrowDataset(df, sparkSession, timeZoneId).collect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowBatchStreamWriter batchWriter = new ArrowBatchStreamWriter(df.schema(), out, timeZoneId);
        batchWriter.writeBatches((Iterator<byte[]>)ArrayOps$.MODULE$.iterator$extension((Object)batches));
        batchWriter.end();
        return out.toByteArray();
    }

    public Dataset<Row> toDataFrame(JavaRDD<byte[]> payloadRDD, StructType schema, SparkSession sparkSession) {
        return this.toDataFrame((RDD<byte[]>)payloadRDD.rdd(), schema, sparkSession);
    }

    public Dataset<Row> toDataFrame(RDD<byte[]> payloadRDD, StructType schema, SparkSession sparkSession) {
        RDD rdd = payloadRDD.mapPartitions((Function1 & Serializable)iter -> {
            ArrowConvertersImpl converters = new ArrowConvertersImpl();
            TaskContext context = TaskContext$.MODULE$.get();
            return converters.fromPayloadIterator((Iterator<byte[]>)iter, context);
        }, payloadRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        Logger logger = new Logger("Arrow", 0);
        Invoke invoke = new Invoke();
        boolean streaming = false;
        return (Dataset)invoke.invoke(sparkSession.sqlContext().getClass(), "", sparkSession.sqlContext(), "internalCreateDataFrame", new Object[]{rdd, schema, streaming}, logger);
    }

    public static final /* synthetic */ byte[] $anonfun$fromPayloadArray$1(byte[] record) {
        return record;
    }

    public static final /* synthetic */ Row $anonfun$fromPayloadArray$2(Function1 converter$1, InternalRow x$1) {
        return (Row)converter$1.apply((Object)x$1);
    }

    private ArrowConverters$() {
    }
}

