% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{sim_asy_pvoigt}
\alias{sim_asy_pvoigt}
\title{Generate an asymmetric pseudo-Voigt resonance in the frequency domain.}
\usage{
sim_asy_pvoigt(
  freq = 0,
  fwhm = 0,
  lg = 0,
  asy = 0,
  acq_paras = def_acq_paras(),
  gen_im_pts = FALSE
)
}
\arguments{
\item{freq}{resonance frequency in ppm.}

\item{fwhm}{resonance FWHM.}

\item{lg}{Lorentz-Gauss lineshape parameter (between 0 and 1).}

\item{asy}{asymmetry parameter.}

\item{acq_paras}{list of acquisition parameters. See
\code{\link{def_acq_paras}}}

\item{gen_im_pts}{option to generate imaginary data points, defaults to
FALSE.}
}
\description{
Method is described in detail by Stancik AL and Brauns EB: "A simple
asymmetric lineshape for fitting infrared absorption spectra." Vib Spectrosc.
2008; 47: 66-69.
}
