% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iDist.R
\name{iDist}
\alias{iDist}
\title{Calculate distance matrix}
\usage{
iDist(coords.1, coords.2, ...)
}
\arguments{
\item{coords.1}{an \eqn{n\times p} matrix with each row corresponding to
a point in \eqn{p}-dimensional space.}

\item{coords.2}{an \eqn{m\times p} matrix with each row corresponding to
a point in \eqn{p} dimensional space. If this is missing then
\code{coords.1} is used.}

\item{...}{currently no additional arguments.}
}
\value{
The \eqn{n\times n} or \eqn{n\times m} inter-site Euclidean
distance matrix.
}
\description{
Computes the inter-site Euclidean distance matrix for one or two sets of
points.
}
\examples{
n <- 10
p1 <- cbind(runif(n),runif(n))
m <- 5
p2 <- cbind(runif(m),runif(m))
D <- iDist(p1, p2)
}
\author{
Soumyakanti Pan \href{mailto:span18@ucla.edu}{span18@ucla.edu},\cr
Sudipto Banerjee \href{mailto:sudipto@ucla.edu}{sudipto@ucla.edu}
}
\keyword{utilities}
