% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{clumper}
\alias{clumper}
\title{Clump a sequence into large segments}
\usage{
clumper(x, minLength, n = length(x))
}
\arguments{
\item{x}{a vector: anything that can be converted into an integer to call
diff(): factors, integers, characters, booleans}

\item{minLength}{the minimum length of a segment (interger or vector)}
}
\value{
Returns the original sequence x transformed to homogeneous segments
  of required length, with the original class (e.g. character or factor).
}
\description{
Internal soundgen function.
}
\details{
\code{clumper} makes sure each homogeneous segment in a sequence is at least
minLength long. Called by getIntegerRandomWalk(), addSubh(), naiveBayes(),
etc. Algorithm: find the epochs shorter than minLength, merge max 1/4 of them
with the largest neighbor, and repeat recursively until all epochs are at
least minLength long. minLength can be a vector, in which case it is assumed
to change over time.
}
\examples{
s = c(1,3,2,2,2,0,0,4,4,1,1,1,1,1,3,3)
soundgen:::clumper(s, 2)
soundgen:::clumper(s, 3)
soundgen:::clumper(1:5, 10)
soundgen:::clumper(c('a','a','a','b','b','c','c','c','a','c'), 3)
soundgen:::clumper(x = c(1,2,1,2,1,1,1,1,3,1), minLength = c(1, 1, 1, 3))
soundgen:::clumper(as.factor(c('A','B','B','C')), 2)
}
\keyword{internal}
